/**
 * @(#)IPropQueryApi 1.0 2018-11-29
 * <p>
 * Copyright (c) 2016, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.item.api.base.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.PropGroupReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.PropNameReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.*;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;

import javax.validation.Valid;
import java.util.List;

/**
 * 属性管理查询接口
 *
 * @author 双清
 */
@Api(tags = {"商品中心：属性服务"})
@FeignClient(name = "${yundt.cube.center.item.api.name:yundt-cube-center-item}",
        contextId = "com-dtyunxi-yundt-cube-center-item-api-base-query-IPropQueryApi",
        path = "/v1/prop",
        url = "${yundt.cube.center.item.api:}")
public interface IPropQueryApi {

    /**
     * 根据主键Id查询属性名
     *
     * @param propNameId 属性名
     * @return 属性名响应dto
     */
    @GetMapping(value = "/{propNameId}", produces = "application/json")
    @ApiOperation(value = "根据主键Id查询属性名", notes = "根据主键Id查询属性名 \n propNameId:属性名ID")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "propNameId", value = "属性名Id", dataType = "Long", paramType = "path")
    })
    RestResponse<PropNameRespDto> queryPropNameById(@PathVariable("propNameId") Long propNameId);

    /**
     * 根据关键字模糊查询属性名
     *
     * @param keyword  关键字
     * @param pageNum  页码
     * @param pageSize 每页记录数
     * @return 返回PropNameSearchRespDto列表
     */
    @GetMapping(value = "/search/propName", produces = "application/json")
    @ApiOperation(value = "根据关键字模糊查询属性名", notes = "根据关键字模糊查询属性名")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "keyword", value = "属性名关键字", dataType = "String", paramType = "query"),
            @ApiImplicitParam(name = "pageNum", value = "分页", dataType = "Long", paramType = "query"),
            @ApiImplicitParam(name = "pageSize", value = "分页大小", dataType = "Long", paramType = "query")
    })
    RestResponse<PropNameSearchRespDto> queryPropNameByName(@RequestParam("keyword") String keyword,
                                                            @RequestParam(name = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                            @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize);

    /**
     * 分页查询属性名列表
     *
     * @param pageNum  页码
     * @param pageSize 每页记录数
     * @return 返回属性名分页列表
     */
    @GetMapping(value = "/propName/page", produces = "application/json")
    @ApiOperation(value = "分页查询属性名列表", notes = "分页查询属性名列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "propNameReqDto", value = "属性名查询条件", dataType = "PropNameReqDto"),
            @ApiImplicitParam(name = "pageNum", value = "分页", dataType = "Long", paramType = "query"),
            @ApiImplicitParam(name = "pageSize", value = "分页大小", dataType = "Long", paramType = "query")
    })
    RestResponse<PageInfo<PropNameRespDto>> queryPropNameByPage(@Valid @ModelAttribute PropNameReqDto propNameReqDto,
                                                                @RequestParam(name = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                                @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize);

    /**
     * 根据目录id查询属性/属性组
     *
     * @param dirId 目录id
     * @return 目录属性响应dto列表
     */
    @GetMapping(value = "/dir/prop/relation/{dirId}", produces = "application/json")
    @ApiOperation(value = "根据目录id查询属性/属性组", notes = "根据目录id查询属性/属性组")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "dirId", value = "目录属性主键Id", dataType = "Long", paramType = "path")
    })
    RestResponse<List<DirPropRelationRespDto>> queryDirPropRelationById(@PathVariable("dirId") Long dirId);

    /**
     * 根据主键Id查询属性组
     *
     * @param propGroupId 属性组主键Id
     * @return 属性组响应dto
     */
    @GetMapping(value = "/propGroup/{propGroupId}", produces = "application/json")
    @ApiOperation(value = "根据主键Id查询属性组", notes = "根据主键Id查询属性组")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "propGroupId", value = "属性组主键id", dataType = "Long", paramType = "path")
    })
    RestResponse<PropGroupRespDto> queryPropGroupById(@PathVariable("propGroupId") Long propGroupId);

    /**
     * 根据关键字模糊查询属性组
     *
     * @param keyword  关键字
     * @param pageNum  页码
     * @param pageSize 每页记录数
     * @return 返回PropGroupSearchRespDto列表
     */
    @GetMapping(value = "/search/propGroup", produces = "application/json")
    @ApiOperation(value = "根据关键字模糊查询属性组", notes = "根据关键字模糊查询属性组")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "keyword", value = "属性组关键字", dataType = "String", paramType = "query"),
            @ApiImplicitParam(name = "pageNum", value = "分页", dataType = "Long", paramType = "query"),
            @ApiImplicitParam(name = "pageSize", value = "分页大小", dataType = "Long", paramType = "query")
    })
    RestResponse<PropGroupSearchRespDto> queryPropGroupByName(@RequestParam("keyword") String keyword,
                                                              @RequestParam(name = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                              @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize);

    /**
     * 分页查询属性组列表
     *
     * @param propGroupReqDto 属性组请求dto
     * @param pageNum         页码
     * @param pageSize        每页记录数
     * @return 返回属性名分页列表
     */
    @GetMapping(value = "/propGroup/page", produces = "application/json")
    @ApiOperation(value = "分页查询属性组列表", notes = "分页查询属性组列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "propGroupReqDto", value = "属性组请求dto", dataType = "PropGroupReqDto"),
            @ApiImplicitParam(name = "pageNum", value = "分页", dataType = "Long", paramType = "query"),
            @ApiImplicitParam(name = "pageSize", value = "分页大小", dataType = "Long", paramType = "query")
    })
    RestResponse<PageInfo<PropGroupRespDto>> queryPropGroupByPage(@Valid @ModelAttribute PropGroupReqDto propGroupReqDto,
                                                                  @RequestParam(name = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                                  @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize);

    /**
     * 查询商品属性关联列表
     *
     * @param filter 查询条件
     * @return 商品属性关联列表
     */
    @GetMapping(value = "/item/prop/relation", produces = "application/json")
    @ApiOperation(value = "查询商品属性关联列表", notes = "查询商品属性关联列表，filter=ItemPropRelationReqDto")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "filter", value = "查询条件", dataType = "ItemPropRelationReqDto")
    })
    RestResponse<List<ItemPropRelationRespDto>> queryItemPropRelation(@RequestParam("filter") String filter);


    @GetMapping(value = "/{dirId}/propName")
    @ApiOperation(value = "根据目录ID和属性组用途查询类目下的属性名列表", notes = "根据目录ID和属性组用途查询类目下的属性名列表")
    RestResponse<List<PropNameRespDto>> queryPropNameListByDirId(@PathVariable("dirId") Long dirId, @RequestParam(value = "usageType", required = false) Integer usageType);




}