package com.dtyunxi.yundt.cube.center.item.api.constants;

import lombok.Getter;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;

@Getter
public enum LengthUnitEnum {

    //M
    NAM("NAM","纳米",new BigDecimal("1"),new BigDecimal("0.0000000001")),
    uM("uM","微米",new BigDecimal("1"),new BigDecimal("0.0000001")),
    MM("MM","毫米",new BigDecimal("1"),new BigDecimal("0.001")),
    CM("CM","厘米",new BigDecimal("1"),new BigDecimal("0.01")),
    DM("DM","分米",new BigDecimal("1"),new BigDecimal("0.1")),
    M("M","米",new BigDecimal("1"),new BigDecimal("1")),
    FT("FT","英尺",new BigDecimal("1"),new BigDecimal("0.3048")),
    KM("KM","公里",new BigDecimal("1"),new BigDecimal("1000")),
    MI("MI","英里",new BigDecimal("1"),new BigDecimal("1609.344")),

    Ml("Ml.","密耳",new BigDecimal("1"),new BigDecimal("0.0000254")),
    YD("YD","码",new BigDecimal("1"),new BigDecimal("0.9144")),

    //CM
    MM01("MM","毫米",new BigDecimal("1"),new BigDecimal("0.1")),
    CM01("CM","厘米",new BigDecimal("1"),new BigDecimal("1")),
    DM01("DM","分米",new BigDecimal("1"),new BigDecimal("10")),
    M01("M","米",new BigDecimal("1"),new BigDecimal("100")),
    ;

    private String unit;
    private String name;
    private BigDecimal baseNum;
    private BigDecimal conversionNum;

    LengthUnitEnum(String unit, String name, BigDecimal baseNum, BigDecimal conversionNum) {
        this.unit = unit;
        this.name = name;
        this.baseNum = baseNum;
        this.conversionNum = conversionNum;
    }

    public static final Map<String, LengthUnitEnum> BANK_TYP_ENUM_MAP = new HashMap<>();
    public static final Map<String, LengthUnitEnum> M_TYP_ENUM_MAP = new HashMap<>();

    static {
        BANK_TYP_ENUM_MAP.put(LengthUnitEnum.MM01.getUnit(), MM01);
        BANK_TYP_ENUM_MAP.put(LengthUnitEnum.CM01.getUnit(), CM01);
        BANK_TYP_ENUM_MAP.put(LengthUnitEnum.DM01.getUnit(), DM01);
        BANK_TYP_ENUM_MAP.put(LengthUnitEnum.M01.getUnit(), M01);
    }
    static {
        M_TYP_ENUM_MAP.put(LengthUnitEnum.NAM.getUnit(), NAM);
        M_TYP_ENUM_MAP.put(LengthUnitEnum.uM.getUnit(), uM);
        M_TYP_ENUM_MAP.put(LengthUnitEnum.MM.getUnit(), MM);
        M_TYP_ENUM_MAP.put(LengthUnitEnum.CM.getUnit(), CM);
        M_TYP_ENUM_MAP.put(LengthUnitEnum.DM.getUnit(), DM);
        M_TYP_ENUM_MAP.put(LengthUnitEnum.M.getUnit(), M);
        M_TYP_ENUM_MAP.put(LengthUnitEnum.FT.getUnit(), FT);

        M_TYP_ENUM_MAP.put(LengthUnitEnum.KM.getUnit(), KM);
        M_TYP_ENUM_MAP.put(LengthUnitEnum.MI.getUnit(), MI);
        M_TYP_ENUM_MAP.put(LengthUnitEnum.Ml.getUnit(), Ml);
        M_TYP_ENUM_MAP.put(LengthUnitEnum.YD.getUnit(), YD);
    }

    public static LengthUnitEnum getUnit(String unit) {
        LengthUnitEnum businessEnum = BANK_TYP_ENUM_MAP.get(unit);
        return businessEnum;
    }

    public static LengthUnitEnum getEnumByUnit(String unit){
        LengthUnitEnum businessEnum = M_TYP_ENUM_MAP.get(unit);
        return businessEnum;
    }

}
