package com.dtyunxi.yundt.cube.center.item.api.dto.request;

import com.dtyunxi.dto.RequestDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;
import java.util.List;

@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "ItemControlPriceDto", description = "商品价格控制Eo对象")
public class ItemControlPriceDto extends RequestDto {

    @ApiModelProperty(name = "type", value = "类型")
    private Integer type;

    @ApiModelProperty(name = "productCode", value = "商品编码")
    private String productCode;

    @ApiModelProperty(name = "productUnit", value = "商品单位")
    private String productUnit;

    @ApiModelProperty(name = "trenchDtoList", value = "编辑价格信息")
    private List<TrenchDto> trenchDtoList;

    @Data
    public static class TrenchDto{
        /**
         *  客户/渠道编码
         */
        @ApiModelProperty(name = "code", value = "客户/渠道编码")
        private String code;
        /**
         *  客户/渠道名称
         */
        @ApiModelProperty(name = "name", value = "客户/渠道名称")
        private String name;

        @ApiModelProperty(name = "price", value = "价格")
        private BigDecimal price;

        @ApiModelProperty(name = "remark", value = "备注")
        private String remark;

        @ApiModelProperty(name = "together", value = "是否同步渠道")
        private Boolean together;
    }
}
