package com.dtyunxi.yundt.cube.center.item.api.dto.response;

import com.dtyunxi.dto.BaseRespDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;

@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "ItemConversionRecordRespDto", description = "商品数据单位转换DTO对象")
public class ItemConversionRecordRespDto extends BaseRespDto {
    /**
     *  商品编码
     */
    @ApiModelProperty(name = "itemCode", value = "商品编码")
    private String itemCode;
    /**
     *  商品数量-原始数量
     */
    @ApiModelProperty(name = "itemNum", value = "商品数量-原始数量")
    private BigDecimal itemNum;
    /**
     *  商品单位-原始单位
     */
    @ApiModelProperty(name = "itemUnit", value = "商品单位-原始单位")
    private String itemUnit;

    /**
     *  本方换算数量
     */
    @ApiModelProperty(name = "conversionNum", value = "本方换算数量")
    private Integer conversionNum;
    /**
     *  本方换算单位
     */
    @ApiModelProperty(name = "conversionUnit", value = "本方换算单位")
    private String conversionUnit;
    /**
     *  本方基本单位数量
     */
    @ApiModelProperty(name = "baseUnitNum", value = "本方基本单位数量")
    private Integer baseUnitNum;
    /**
     * 单价
     */
    @ApiModelProperty(name = "itemPrice", value = "本方基本单位单价")
    private BigDecimal itemPrice;//单价
    /**
     * 总价
     */
    @ApiModelProperty(name = "totalItemPrice", value = "本方基本单位总价")
    private BigDecimal totalItemPrice;//总价

    /**
     *  他方换算数量
     */
    @ApiModelProperty(name = "toConversionNum", value = "他方换算数量")
    private Integer toConversionNum;
    /**
     *  他方换算单位
     */
    @ApiModelProperty(name = "toConversionUnit", value = "他方换算单位")
    private String toConversionUnit;
    /**
     *  他方基本单位数量
     */
    @ApiModelProperty(name = "toBaseUnitNum", value = "他方基本单位数量")
    private Integer toBaseUnitNum;

    /**
     *  他方商品数量-换算后数量
     */
    @ApiModelProperty(name = "toItemNum", value = "他方商品数量-换算后数量")
    private BigDecimal toItemNum;
    /**
     *  他方商品单位-换算后后单位
     */
    @ApiModelProperty(name = "toItemUnit", value = "他方商品单位-换算后后单位")
    private String toItemUnit;
    /**
     * 单价
     */
    @ApiModelProperty(name = "baseUnitNum", value = "他方基本单位单价")
    private BigDecimal toItemPrice;//单价
    /**
     * 总价
     */
    @ApiModelProperty(name = "baseUnitNum", value = "他方基本单位总价")
    private BigDecimal toTotalItemPrice;//总价
    /**
     * 批次
     */
    @ApiModelProperty(name = "itemBatch", value = "批次")
    private String itemBatch;
}
