package com.dtyunxi.yundt.cube.center.item.api.dto.response;

import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * <p>Title:ItemExtListRespDto</p>
 * <p>Description: </p>
 *
 * @author yiyun
 * @date 2021/8/26 0:43
 * @since 0.1.0
 */
public class ItemExtListRespDto implements Serializable {

    @ApiModelProperty(name = "itemId", value = "商品ID")
    private Long itemId;

    @ApiModelProperty(name = "itemName", value = "商品名称")
    private String itemName;

    @ApiModelProperty(name = "itemCode", value = "商品编码")
    private String itemCode;

    @ApiModelProperty(name = "itemPrice", value = "商品价格")
    private BigDecimal itemPrice = BigDecimal.ZERO;

    @ApiModelProperty(name = "imagePath", value = "封面")
    private String imagePath;

    /**
     * 状态(0已发布 1上架 2下架 3未发布 4禁用状态)
     */
    @ApiModelProperty(name = "status", value = "上下架状态")
    private Integer status;

    /**
     * 是否允许销
     */
    @ApiModelProperty(name = "allow", value = "是否允销")
    private Boolean allow = false;

    @ApiModelProperty(name = "balance", value = "库存数")
    private Long balance = 0L;


    public Long getItemId() {
        return itemId;
    }

    public void setItemId(Long itemId) {
        this.itemId = itemId;
    }

    public String getItemName() {
        return itemName;
    }

    public void setItemName(String itemName) {
        this.itemName = itemName;
    }

    public String getItemCode() {
        return itemCode;
    }

    public void setItemCode(String itemCode) {
        this.itemCode = itemCode;
    }

    public BigDecimal getItemPrice() {
        return itemPrice;
    }

    public void setItemPrice(BigDecimal itemPrice) {
        this.itemPrice = itemPrice;
    }

    public String getImagePath() {
        return imagePath;
    }

    public void setImagePath(String imagePath) {
        this.imagePath = imagePath;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public Boolean getAllow() {
        return allow;
    }

    public void setAllow(Boolean allow) {
        this.allow = allow;
    }

    public Long getBalance() {
        return balance;
    }

    public void setBalance(Long balance) {
        this.balance = balance;
    }
}
