/*
 * @(#)ItemRelationInfoRespDto.java 1.0 2021年09月15日
 *
 *  Copyright (c) 2016, YUNXI. All rights reserved.
 *  YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.dtyunxi.yundt.cube.center.item.api.dto.response;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * <p>Title:ItemRelationInfoRespDto</p>
 * <p>Description: </p>
 *
 * @author yiyun.lkh
 * @date 2021/9/15 11:07
 * @since 0.1.0
 */
@ApiModel(value = "ItemRelationInfoRespDto", description = "商品关系对照Dto对象")
@Data
public class ItemRelationInfoRespDto implements Serializable {
    @ApiModelProperty(name = "id", value = "ID")
    private Long id;
    @ApiModelProperty(name = "channel", value = "商品映射所属平台")
    private String channel;
    @ApiModelProperty(name = "platformId", value = "所属平台")
    private String platformId;
    @ApiModelProperty(name = "platformName", value = "所属平台名称")
    private String platformName;
    @ApiModelProperty(name = "shopCode", value = "所属店铺编码")
    private String shopCode;
    @ApiModelProperty(name = "channelItemId", value = "平台商品ID")
    private String channelItemId;
    @ApiModelProperty(name = "channelItemCode", value = "平台商品编码")
    private String channelItemCode;
    @ApiModelProperty(name = "channelItemName", value = "平台商品名称")
    private String channelItemName;
    @ApiModelProperty(name = "channelSkuId", value = "平台skuId")
    private String channelSkuId;
    @ApiModelProperty(name = "channelSkuCode", value = "平台sku编码")
    private String channelSkuCode;

    @ApiModelProperty(name = "relationState", value = "关联状态：YES：已关联；NO：未关联")
    private String relationState;

    @ApiModelProperty(name = "itemId", value = "商品ID")
    private Long itemId;

    @ApiModelProperty(name = "code", value = "物料编码")
    private String code;
    @ApiModelProperty(name = "name", value = "物料名称")
    private String name;
    @ApiModelProperty(name = "prodLargeClass", value = "产品大类(北鼎一级品类描述)")
    private String prodLargeClass;
    @ApiModelProperty(name = "prodLargeCode", value = "产品大类编码(北鼎一级品类)")
    private String prodLargeCode;
    @ApiModelProperty(name = "prodSecClassify", value = "产品二级分类(北鼎二级品类描述)")
    private String prodSecClassify;
    @ApiModelProperty(name = "prodSecCode", value = "产品二级分类编码(北鼎二级品类)")
    private String prodSecCode;
    @ApiModelProperty(name = "prodThrClassify", value = "产品三级分类(北鼎三级品类描述)")
    private String prodThrClassify;
    @ApiModelProperty(name = "prodThrCode", value = "产品三级分类编码(北鼎三级品类)")
    private String prodThrCode;
    @ApiModelProperty(name = "prodClassCode", value = "产品型号")
    private String prodClassCode;
    @ApiModelProperty(name = "prodClassName", value = "产品名称")
    private String prodClassName;
    @ApiModelProperty(name = "shopName", value = "店铺名称")
    private String shopName;
    @ApiModelProperty(name = "shopId", value = "店铺ID")
    private String shopId;
    @ApiModelProperty(name = "skuCode", value = "skuCode")
    private String skuCode;
    @ApiModelProperty(name = "skuId", value = "平台SKUID")
    private String skuId;

}
