package com.dtyunxi.yundt.cube.center.item.api.dto.response;

import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemMediasRespDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * <p>Title:ShelfListRespDto</p>
 * <p>Description: </p>
 *
 * @author yiyun
 * @date 2021/9/1 16:09
 * @since 0.1.0
 */
@Data
@ApiModel(value = "ShelfListRespDto", description = "商品上下架列表定义Dto对象")
public class ShelfListRespDto implements Serializable {

    @ApiModelProperty(name = "id", value = "主键id")
    private Long id;

    @ApiModelProperty(name = "skuId", value = "skuId")
    private Long skuId;

    @ApiModelProperty(name = "shopId", value = "店铺Id")
    private Long shopId;

    @ApiModelProperty(name = "itemId", value = "商品ID")
    private Long itemId;

    @ApiModelProperty(name = "itemCode", value = "商品编码")
    private String itemCode;

    @ApiModelProperty(name = "itemName", value = "商品名称")
    private String itemName;

    @ApiModelProperty(name = "prodLargeCode", value = "产品大类编码(北鼎一级品类)")
    private String prodLargeCode;

    @ApiModelProperty(name = "prodLargeClass", value = "产品大类(北鼎一级品类描述)")
    private String prodLargeClass;

    @ApiModelProperty(name = "prodSecCode", value = "产品二级分类编码(北鼎二级品类)")
    private String prodSecCode;

    @ApiModelProperty(name = "prodSecClassify", value = "产品二级分类(北鼎二级品类描述)")
    private String prodSecClassify;

    @ApiModelProperty(name = "prodThrCode", value = "产品三级分类编码(北鼎三级品类)")
    private String prodThrCode;

    @ApiModelProperty(name = "prodThrClassify", value = "产品三级分类(北鼎三级品类描述)")
    private String prodThrClassify;

    @ApiModelProperty(name = "prodClassCode", value = "产品型号")
    private String prodClassCode;

    @ApiModelProperty(name = "prodClassName", value = "产品名称")
    private String prodClassName;

    @ApiModelProperty(name = "principalPerson", value = "负责人")
    private String principalPerson;

    @ApiModelProperty(name = "dirId", value = "后台类目ID")
    private Long dirId;

    @ApiModelProperty(name = "dirName", value = "后台类目名称")
    private String dirName;

    @ApiModelProperty(name = "dirPrefixId", value = "前台类目ID")
    private Long dirPrefixId;

    @ApiModelProperty(name = "dirPrefixName", value = "前台类目名称")
    private String dirPrefixName;

    @ApiModelProperty(name = "enCode", value = "EAN码")
    private String enCode;

    @ApiModelProperty(name = "itemStatus", value = "上架状态")
    private Integer shelfStatus;

    @ApiModelProperty(name = "shelfAddress", value = "上架地址(0:国内B2B商城,1:国外B2B商城)")
    private String shelfAddress;

    @ApiModelProperty(name = "platformNames", value = "允销平台")
    private String platformNames;


    @ApiModelProperty(name = "platformIds", value = "允销平台ID")
    private String platformIds;

    @ApiModelProperty(name = "updateTime", value = "更新时间")
    private String updateTime;

    @ApiModelProperty(name = "createTime", value = "创建时间")
    private String createTime;
    @ApiModelProperty(name = "type", value = "1-商品，2.产品 3组合商品 4虚拟商品 5赠品商品")
    private Integer type;

    @ApiModelProperty(name = "subItemCodeMap", value = "subItemCodeMap")
    private Map<String, Integer> subItemCodeMap;

    @ApiModelProperty(name = "salesCount", value = "销量")
    private Long salesCount;
    @ApiModelProperty(name = "inventoryQuantity", value = "库存数")
    private Long inventoryQuantity;

    @ApiModelProperty(name = "price", value = "价格")
    private BigDecimal price= BigDecimal.ZERO;

    @ApiModelProperty(name = "itemMediasList", value = "商品多媒体")
    private List<ItemMediasRespDto> itemMediasList;

    @ApiModelProperty(name = "imagePath", value = "商品主图")
    private String imagePath;

    @ApiModelProperty(name = "bundlesDetailRespDtos",value = "查询子商品详情")
    private List<ItemBundlesDetailRespDto> bundlesDetailRespDtos;

    @ApiModelProperty(name = "saleGroup",value = "销售组")
    private List<String> saleGroup;

}
