package com.yunxi.adapter.api.dto.request;

import com.dtyunxi.annotation.LogicColumn;
import com.dtyunxi.dto.RequestDto;
import com.yunxi.dg.base.commons.dto.BaseDto;
import com.yunxi.dg.base.commons.dto.BasePageDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 商品扩展参数表Eo对象
 * @author yuanyi
 */
@Data
@ApiModel(value = "ItemExtendAdapterReqDto", description = "商品扩展参数适配查询对象")
public class ItemExtendAdapterReqDto extends BasePageDto {
    /**
     *  编码
     */
    @ApiModelProperty(name = "itemCode", value = "编码")
    @LogicColumn
    private String itemCode;

    /**
     * e3物料编码
     */
    @ApiModelProperty(name = "e3ItemCode", value = "e3物料编码")
    private String e3ItemCode;

    /**
     *  旧批文
     */
    @ApiModelProperty(name = "oldApproval", value = "旧批文")
    private String oldApproval;

    /**
     *  旧货品名称
     */
    @ApiModelProperty(name = "oldItemName", value = "旧货品名称")
    private String oldItemName;

    /**
     *  启用日期
     */
    @ApiModelProperty(name = "enableDate", value = "启用日期")
    private Date enableDate;

    /**
     *  停用日期
     */
    @ApiModelProperty(name = "disableDate", value = "停用日期")
    private Date disableDate;

    private String barCode;
    /**
     *  编码列表
     */
    @ApiModelProperty(name = "itemCodeList", value = "编码列表(skuCode)")
    private List<String> itemCodeList;
    /**
     *  长度
     */
    @ApiModelProperty(name = "length", value = "长度")
    private BigDecimal length;
    /**
     *  高度
     */
    @ApiModelProperty(name = "height", value = "高度")
    private BigDecimal height;
    /**
     *  宽度
     */
    @ApiModelProperty(name = "width", value = "宽度")
    private BigDecimal width;
    /**
     *  长单位，单位可选mm/cm/dm/m（毫米/厘米/分米/米），默认cm
     */
    @ApiModelProperty(name = "lengthUnit", value = "长单位，单位可选mm/cm/dm/m（毫米/厘米/分米/米），默认cm")
    private String lengthUnit;
    /**
     *  高单位，单位可选mm/cm/dm/m（毫米/厘米/分米/米），默认cm
     */
    @ApiModelProperty(name = "heightUnit", value = "高单位，单位可选mm/cm/dm/m（毫米/厘米/分米/米），默认cm")
    private String heightUnit;
    /**
     *  宽单位，单位可选mm/cm/dm/m（毫米/厘米/分米/米），默认cm
     */
    @ApiModelProperty(name = "widthUnit", value = "宽单位，单位可选mm/cm/dm/m（毫米/厘米/分米/米），默认cm")
    private String widthUnit;
    /**
     *  体积
     */
    @ApiModelProperty(name = "volume", value = "体积")
    private BigDecimal volume;
    /**
     *  体积单独
     */
    @ApiModelProperty(name = "volumnUnit", value = "体积单位")
    private String volumnUnit;
    /**
     *  毛重
     */
    @ApiModelProperty(name = "grossWeight", value = "毛重")
    private BigDecimal grossWeight;
    /**
     *  毛重单位
     */
    @ApiModelProperty(name = "grossWeightUnit", value = "毛重单位")
    private String grossWeightUnit;
    /**
     *  净重
     */
    @ApiModelProperty(name = "netWeight", value = "净重")
    private BigDecimal netWeight;
    /**
     *  净重单位
     */
    @ApiModelProperty(name = "netWeightUnit", value = "净重单位")
    private String netWeightUnit;
    /**
     *  重量
     */
    @ApiModelProperty(name = "quantity", value = "重量")
    private BigDecimal quantity;
    /**
     *  重量单位
     */
    @ApiModelProperty(name = "quantityUnit", value = "重量单位")
    private String quantityUnit;
    /**
     *  大包系数
     */
    @ApiModelProperty(name = "bigRatio", value = "大包系数")
    private Long bigRatio;
    /**
     *  中包系数
     */
    @ApiModelProperty(name = "middleRatio", value = "中包系数")
    private Long middleRatio;
    /**
     *  小包系数
     */
    @ApiModelProperty(name = "smallRatio", value = "小包系数")
    private Long smallRatio;
    /**
     *  防伪码
     */
    @ApiModelProperty(name = "securityCode", value = "防伪码")
    private String securityCode;
    /**
     *  保质期
     */
    @ApiModelProperty(name = "expirationDate", value = "保质期")
    private String expirationDate;

    @ApiModelProperty(name = "zhTrayNum", value = "珠海仓托盘数")
    private String zhTrayNum;
    /**
     *  保质期单位
     */
    @ApiModelProperty(name = "expirationUnit", value = "保质期单位")
    private String expirationUnit;
    /**
     *  是否免检
     */
    @ApiModelProperty(name = "exemption", value = "是否免检")
    private String exemption;

    private String specifications;

    private BigDecimal recommendPrice;

    private String imeiCodeFlag;

    /**
     *  标准批文
     */
    private String standardApproval;
    private String cfproducers;

    private String itemDrug;
    private String unitId;

    /**
     *  大包系数
     */
    @ApiModelProperty(name = "big_box")
    private Long bigBox;
    /**
     *  中包系数
     */
    @ApiModelProperty(name = "middle_box")
    private Long middleMax;
    /**
     *  小包系数
     */
    @ApiModelProperty(name = "small_box")
    private Long smallBox;

    /**
     *  索赔价格
     */
    @ApiModelProperty(name = "claimPrice", value = "索赔价格")
    private BigDecimal claimPrice;

    @ApiModelProperty(name = "stockUnit", value = "单位")
    private String stockUnit;
}
