/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.item.api.utils;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public class UnitFormatUtils {
    private static final UnitFormatService ceilingFormatService = (val, origLarge, targetLager) -> Optional.ofNullable(val).orElse(BigDecimal.ZERO).multiply(BigDecimal.valueOf(origLarge)).divide(BigDecimal.valueOf(targetLager), 8, RoundingMode.CEILING);
    private static final UnitFormatService evenFormatService = (val, origLarge, targetLager) -> Optional.ofNullable(val).orElse(BigDecimal.ZERO).multiply(BigDecimal.valueOf(origLarge)).divide(BigDecimal.valueOf(targetLager), 0, RoundingMode.HALF_EVEN);

    public static BigDecimal formatVolume(BigDecimal val, String origUnit, String targetUnit) {
        VolumeEnum volumeEnum = VolumeEnum.forCode(origUnit);
        VolumeEnum targetEnum = VolumeEnum.forCode(targetUnit);
        if (volumeEnum == null || targetEnum == null) {
            return BigDecimal.ZERO;
        }
        return ceilingFormatService.format(val, volumeEnum.getLargeNum(), targetEnum.largeNum);
    }

    public static Long formatDate(Long val, String origUnit, String targetUnit) {
        DateEnum volumeEnum = DateEnum.forCode(origUnit);
        DateEnum targetEnum = DateEnum.forCode(targetUnit);
        if (volumeEnum == null || targetEnum == null) {
            return 0L;
        }
        return evenFormatService.format(new BigDecimal(val), volumeEnum.getLargeNum(), targetEnum.largeNum).longValue();
    }

    @FunctionalInterface
    public static interface UnitFormatService {
        public BigDecimal format(BigDecimal var1, Long var2, Long var3);
    }

    public static enum VolumeEnum {
        CM("\u7acb\u65b9\u5398\u7c73", 1L),
        MM("\u7acb\u65b9\u5206\u7c73", 1000L),
        M("\u7acb\u65b9\u7c73", 1000000L);

        private final String name;
        private final Long largeNum;
        public static final Map<String, VolumeEnum> CODE_LOOKUP;

        private VolumeEnum(String name, Long largeNum) {
            this.name = name;
            this.largeNum = largeNum;
        }

        public String getName() {
            return this.name;
        }

        public Long getLargeNum() {
            return this.largeNum;
        }

        public static VolumeEnum forCode(String code) {
            return CODE_LOOKUP.get(code);
        }

        static {
            CODE_LOOKUP = Arrays.stream(VolumeEnum.values()).collect(Collectors.toMap(VolumeEnum::getName, thisEnum -> thisEnum));
        }
    }

    public static enum DateEnum {
        DAY("\u65e5", 1L),
        MONTH("\u6708", 30L),
        YEAR("\u5e74", 365L);

        private final String name;
        private final Long largeNum;
        public static final Map<String, DateEnum> CODE_LOOKUP;

        private DateEnum(String name, Long largeNum) {
            this.name = name;
            this.largeNum = largeNum;
        }

        public String getName() {
            return this.name;
        }

        public Long getLargeNum() {
            return this.largeNum;
        }

        public static DateEnum forCode(String code) {
            return CODE_LOOKUP.get(code);
        }

        static {
            CODE_LOOKUP = Arrays.stream(DateEnum.values()).collect(Collectors.toMap(DateEnum::getName, thisEnum -> thisEnum));
        }
    }
}

