package com.dtyunxi.yundt.cube.center.item.api.base.dto.request;

import com.dtyunxi.dto.RequestDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.List;

@ApiModel(value = "ItemShelfQueryReqDto", description = "上架商品查询Dto")
public class ItemShelfQueryReqDto extends RequestDto {

    @ApiModelProperty(name = "itemStatus", value = "商品状态: 1 已上架 2已下架")
    private Integer itemStatus;

    @ApiModelProperty(name = "sellOut", value = "是否已经售罄")
    private Boolean sellOut;

    @ApiModelProperty(name = "itemName", value = "商品名称")
    private String itemName;

    @ApiModelProperty(name = "itemCode", value = "商品编码")
    private String itemCode;

    @ApiModelProperty(name = "skuCode", value = "SKU编码")
    private String skuCode;

    @ApiModelProperty(name = "shopId", value = "店铺ID")
    private Long shopId;

    @ApiModelProperty(name = "sellerId", value = "商户ID")
    private Long sellerId;

    @ApiModelProperty(name = "shelfType", value = "上架类型：1 普通上架  2 周期购上架")
    private Integer shelfType;
    @ApiModelProperty(name = "itemType", value = "商品类型：1普通商品 2积分商品")
    private Integer itemType;
    @ApiModelProperty(name = "busType", value = "上架业务类型：0普通商品 2 积分商品")
    private Integer busType;

    /**
     * 查询数据分组方式：1 shopId+itemId;2 itemId
     */
    @ApiModelProperty(name = "groupBy", value = "查询数据分组方式:1按店铺+商品；2商品，默认1")
    private Integer groupBy;

    /**
     * 店铺ids
     */
    @ApiModelProperty(name = "shopIds", value = "店铺ID列表")
    private List<Long> shopIds;

    /**
     * 品牌ids
     */
    @ApiModelProperty(name = "brandIds", value = "品牌ID列表")
    private List<Long> brandIds;

    /**
     * 类目ids
     */
    @ApiModelProperty(name = "dirIds", value = "类目id列表")
    private List<Long> dirIds;

    @ApiModelProperty(name = "distribution", value = "是否分销：1是，0否")
    private Integer distribution;

    @ApiModelProperty(name = "sellerIds", value = "商户ID列表")
    private List<Long> sellerIds;

    @ApiModelProperty(name = "subType", value = "商品子类型，1-产品，2-赠品，3-物料")
    private Integer subType;

    @ApiModelProperty(name = "dosageForm", value = "剂型")
    private String dosageForm;

    @ApiModelProperty(name = "outSkuIds", value = "在商品Sku的id集合外查询")
    private List<Long> outSkuIds;

    public List<Long> getOutSkuIds() {
        return outSkuIds;
    }

    public void setOutSkuIds(List<Long> outSkuIds) {
        this.outSkuIds = outSkuIds;
    }

    public String getDosageForm() {
        return dosageForm;
    }

    public void setDosageForm(String dosageForm) {
        this.dosageForm = dosageForm;
    }

    public Integer getSubType() {
        return subType;
    }

    public void setSubType(Integer subType) {
        this.subType = subType;
    }

    public List<Long> getSellerIds() {
        return sellerIds;
    }

    public void setSellerIds(List<Long> sellerIds) {
        this.sellerIds = sellerIds;
    }

    public Integer getBusType() {
        return busType;
    }

    public void setBusType(Integer busType) {
        this.busType = busType;
    }

    public Integer getItemType() {
        return itemType;
    }

    public void setItemType(Integer itemType) {
        this.itemType = itemType;
    }

    public Integer getItemStatus() {
        return itemStatus;
    }

    public void setItemStatus(Integer itemStatus) {
        this.itemStatus = itemStatus;
    }

    public Boolean getSellOut() {
        return sellOut;
    }

    public void setSellOut(Boolean sellOut) {
        this.sellOut = sellOut;
    }

    public String getItemName() {
        return itemName;
    }

    public void setItemName(String itemName) {
        this.itemName = itemName;
    }

    public String getItemCode() {
        return itemCode;
    }

    public void setItemCode(String itemCode) {
        this.itemCode = itemCode;
    }

    public String getSkuCode() {
        return skuCode;
    }

    public void setSkuCode(String skuCode) {
        this.skuCode = skuCode;
    }

    public Long getShopId() {
        return shopId;
    }

    public void setShopId(Long shopId) {
        this.shopId = shopId;
    }

    public Integer getGroupBy() {
        return groupBy;
    }

    public void setGroupBy(Integer groupBy) {
        this.groupBy = groupBy;
    }

    public List<Long> getShopIds() {
        return shopIds;
    }

    public void setShopIds(List<Long> shopIds) {
        this.shopIds = shopIds;
    }

    public List<Long> getBrandIds() {
        return brandIds;
    }

    public void setBrandIds(List<Long> brandIds) {
        this.brandIds = brandIds;
    }

    public Long getSellerId() {
        return sellerId;
    }

    public void setSellerId(Long sellerId) {
        this.sellerId = sellerId;
    }

    public Integer getShelfType() {
        return shelfType;
    }

    public void setShelfType(Integer shelfType) {
        this.shelfType = shelfType;
    }

    public List<Long> getDirIds() {
        return dirIds;
    }

    public void setDirIds(List<Long> dirIds) {
        this.dirIds = dirIds;
    }

    public Integer getDistribution() {
        return distribution;
    }

    public void setDistribution(Integer distribution) {
        this.distribution = distribution;
    }
}
