/**
 * @(#) ItemStorageReturnReqDto.java 1.0 2019-06-12
 * Copyright (c) 2019, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.item.api.base.dto.request;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * 库存回退Dto
 *
 * @author 魄罗
 * @since 2.0.0
 */
@ApiModel(value = "ItemStorageReturnReqDto", description = "库存回退Dto")
public class ItemStorageReturnReqDto extends BaseReqDto {

    /**
     * 交易订单号
     */
    @NotNull(message = "交易订单号不允许为空")
    @ApiModelProperty(name = "orderNo", value = "交易订单号，必填")
    private String orderNo;
    /**
     * 要预占商品信息
     */
    @ApiModelProperty(name = "itemList", value = "要预占商品信息，必填")
    private List<ItemStorageInfoReqDto> itemList;

    public String getOrderNo() {
        return orderNo;
    }

    public void setOrderNo(String orderNo) {
        this.orderNo = orderNo;
    }

    public List<ItemStorageInfoReqDto> getItemList() {
        return itemList;
    }

    public void setItemList(List<ItemStorageInfoReqDto> itemList) {
        this.itemList = itemList;
    }
}
