/*
 * @(#)ItemSkuRespDto.java 1.0 2018-09-03
 *
 * 			Copyright (c) 2017, YUNXI. All rights reserved.
 * 			YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.dtyunxi.yundt.cube.center.item.api.base.dto.response;

import com.google.common.collect.Lists;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.List;

/**
 * 商品规格Dto
 *
 * @author 诺克
 * @since 2.0.0
 */
@Data
@ApiModel(value = "ItemSkuRespDto", description = "商品规格Dto")
public class ItemSkuRespDto extends BaseRespDto {

    @ApiModelProperty(name = "id", value = "id")
    private Long id;

    @ApiModelProperty(name = "code", value = "编码")
    private String code;

    @ApiModelProperty(name = "name", value = "规格名")
    private String name;

    @ApiModelProperty(name = "cspuid", value = "产品规格")
    private Long cspuid;

    @ApiModelProperty(name = "attr", value = "属性")
    private String attr;

    @ApiModelProperty(name = "status", value = "状态")
    private Integer status;

    @ApiModelProperty(name = "unit", value = "单位")
    private String unit;

    @ApiModelProperty(name = "barCode", value = "识别条形码")
    private String barCode;

    @ApiModelProperty(name = "bundles", value = "组合信息")
    private String bundles;

    @ApiModelProperty(name = "effectiveStartTime", value = "有效的起始时间（例12:00）,有效日期上架当天")
    private String effectiveStartTime;

    @ApiModelProperty(name = "effectiveEndTime", value = "有效的结束时间（例13:00）,有效日期上架当天")
    private String effectiveEndTime;

    @ApiModelProperty(name = "inventoryQuantity", value = "虚拟商品库存数量")
    private Long inventoryQuantity;

    @ApiModelProperty(name = "advanceSale", value = "是否预售(1是 2否)")
    private Integer advanceSale;

    @ApiModelProperty(name = "discontinuationDate", value = "停售日期")
    private String discontinuationDate;

    @ApiModelProperty(name = "instanceId", value = "应用实例ID")
    private Long instanceId;

    @ApiModelProperty(name = "outterCode", value = "外部编码")
    private String outterCode;

    @ApiModelProperty(name = "cargoCode", value = "货品编码")
    private String cargoCode;

    @ApiModelProperty(name = "itemId", value = "商品id")
    private Long itemId;

    @ApiModelProperty(name = "shelfAmount", value = "可卖数量=所有规格的可卖数量之和")
    private Long shelfAmount;

    @ApiModelProperty(name = "balance", value = "库存数量")
    private Long balance;

    @ApiModelProperty(name = "itemPriceList", value = "价格列表")
    private List<ItemPriceRespDto> itemPriceList = Lists.newArrayList();

    @ApiModelProperty(name = "bundleItemList", value = "组合商品信息")
    private List<BundleItemRespDto> bundleItemList = Lists.newArrayList();

    @ApiModelProperty(name = "medias", value = "商品sku的多媒体信息，选填")
    private List<ItemMediasRespDto> medias = Lists.newArrayList();

    @ApiModelProperty(name = "ifAvailableOffline", value = "是否线下可售，0-否，1-是")
    private Integer ifAvailableOffline;

    @ApiModelProperty(name = "safetyStock", value = "安全库存数")
    private Integer safetyStock;

    @ApiModelProperty(name = "price", value = "定价")
    private BigDecimal price;

    @ApiModelProperty(name = "salePrice", value = "零售价")
    private BigDecimal salePrice;

    /**
     * 退换数量限制
     */
    @ApiModelProperty(name = "cashLimit", value = "积分兑换数量限制")
    private Integer cashLimit;
    /**
     * 退换金额
     */
    @ApiModelProperty(name = "cashAmount", value = "积分兑换金额")
    private BigDecimal cashAmount;
    /**
     * 积分
     */
    @ApiModelProperty(name = "cashIntegral", value = "积分")
    private Long cashIntegral;
    /**
     * 兑换类型：1积分 2积分+金额
     */
    @ApiModelProperty(name = "cashType", value = "兑换类型：1积分2积分+金额")
    private Integer cashType;

    /**
     * 毛重
     */
    @ApiModelProperty(name="grossWeight", value = "毛重")
    private BigDecimal grossWeight;

    /**
     * 毛重单位
     */
    @ApiModelProperty(name="grossWeightUnit", value = "毛重单位")
    private String grossWeightUnit;

    /**
     * 净重
     */
    @ApiModelProperty(name="netWeight", value = "净重")
    private BigDecimal netWeight;

    /**
     * 净重单位
     */
    @ApiModelProperty(name="netWeightUnit", value = "净重单位")
    private String netWeightUnit;

    @ApiModelProperty(name = "distribution", value = "是否分销：1是，0否")
    private Integer distribution;

    @ApiModelProperty(name = "distribution", value = "分销佣金")
    private BigDecimal distributionFee;
    /**
     * 体积
     */
    @ApiModelProperty(name="volume", value = "体积")
    private BigDecimal volume;
    /**
     * 体积单位
     */
    @ApiModelProperty(name="volumeUnit", value = "体积单位")
    private String volumeUnit;
    @ApiModelProperty(name = "freightTemplateId", value = "运费模板id")
    private Long freightTemplateId;
    @ApiModelProperty(name = "freightTemplateName", value = "运费名称")
    private String freightTemplateName;

    @ApiModelProperty(name = "PointsDeductionRespDto", value = "积分扣减规则")
    private PointsDeductionRespDto pointsDeductionRespDto;

    @ApiModelProperty(name = "costPrice",value = "成本价")
    private BigDecimal costPrice;

    @ApiModelProperty(name = "addPriceStatus",value = "0:关闭加价限制;1:开启加价限制")
    private Integer addPriceStatus;
    /**
     * 加价限制设置关闭则不显示
     * @return
     */
    @ApiModelProperty(name = "addPriceMode",value = "加价方式,0:使用默认值;1:自定义比例;2:自定义设置(固定值)")
    private Integer addPriceMode;

    @ApiModelProperty(name = "addPriceMin",value = "限制加价下限;addPriceMod的值为0,1就位百分比;2为固定值(单位元)")
    private String addPriceMin;

    @ApiModelProperty(name = "addPriceMax",value = "限制加价上限")
    private String addPriceMax;

    @ApiModelProperty(name = "shoppingCartItemId",value = "小b端专用，购物车id")
    private Long shoppingCartItemId;

    @ApiModelProperty(name = "shoppingCartItemNum",value = "小b端专用，购物车的数量")
    private Integer shoppingCartItemNum;

    @ApiModelProperty(name = "minPackage",value = "最小包装数")
    private Integer minPackage;

    @ApiModelProperty(name = "stockDisplay", value = "库存显示,1:显示可用库存数量;2:显示库存充足;3:不显示库存")
    private Integer stockDisplay;

    @ApiModelProperty(name = "limitMin", value = "起订量;limit_min_mode的值为1就为固定值;2就为最小包装数倍数")
    private Integer limitMin;

    @ApiModelProperty(name = "limitMinMode", value = "起订量计算方式,1:自定义设置(固定值);2:最小包装数倍数(按最小包装数倍数起订，起订量=最小包装数*最小包装数倍数)")
    private Integer limitMinMode;

    @ApiModelProperty(name = "multipleStatus", value = "订购倍数控制,0:关闭;1:开启(开启时，下单商品数量必须等于起订量的倍数)")
    private Integer multipleStatus;

    @ApiModelProperty(name = "shopId",value = "店铺ID")
    private Long shopId;

    // ==== 北鼎字段 start ====
    /**
     * 规格单位
     */
    private String specsUnit;

    /**
     *  计量单位
     */
    private String calcuUnit;

    /**
     *  重量单位
     */
    private String weightUnit;

    /**
     * 内包装规格（PC长宽高）
     */
    private String pcSpecs;

    /**
     * 外包装规格（CAR长宽高）
     */
    private String carSpecs;

    /**
     * 换算因子
     */
    private String matrixing;

    private String launchDate;

    private String delistingDate;

    private String materialType;
    // ==== 北鼎字段 end ====

    // ==== 华帝字段 start ====
    /*大小/量纲*/
    String capacitySize = null;
    /*面板材质/特征效果*/
    String panelMaterial = null;
    /*容积*/
    //String volume = null;
    /*毛质量*/
    String totalQuality = null;
    /*包装参考物料*/
    String packingMaterial = null;
    /*包装外形尺寸*/
    String packingSize = null;
    /*额定容积*/
    String nominalVolume = null;
    /*净质量*/
    String netQuality = null;
    /*嵌装开孔尺寸*/
    String insertOpeningSize = null;
    /*基本单位*/
    String basicUnit = null;
    /**
     *冻结标识
     * */
    String freezeMark = null;
    /**
     *销售单位
     * */
    @ApiModelProperty(name = "saleUnit",value = "销售单位")
    private String saleUnit;
    /**
     *计价单位
     * */
    @ApiModelProperty(name = "priceUnit",value = "计价单位")
    private String priceUnit;
    /**
     *计价换算系数
     * */
    @ApiModelProperty(name = "priceConversionNum",value = "计价换算系数")
    private BigDecimal priceConversionNum;
    /*规格*/
    //String specification = null;
    /*销售组*/
    //String salesGroup = null;
    // ==== 华帝字段 end ====
}
