package com.dtyunxi.yundt.cube.center.item.api.base.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.PointsDeductionInfoRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;

import java.util.List;

/***
 * 商品上架积分抵扣规则查询
 */
@Api(tags = {"商品中心：属性服务"})
@FeignClient(name = "${yundt.cube.center.item.api.name:yundt-cube-center-item}",
        contextId = "com-dtyunxi-yundt-cube-center-item-api-base-query-IShelfPointsDeductionQueryApi",
        path = "/v1/shelf/pointsDeduction",
        url = "${yundt.cube.center.item.api:}")
public interface IShelfPointsDeductionQueryApi {


    /**
     * 根据上架ID获取相应的自定已积分抵扣规则
     *
     * @param shelfId 上架ID
     * @return
     */
    @GetMapping("/{shelfIds}")
    @ApiOperation(value = "根据上架ID查询上架商品的积分抵扣规则", notes = "根据上架ID查询上架商品的积分抵扣规则")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "shelfIds", value = "上架ID,多个ID使用','隔开", dataType = "String", paramType = "path")
    })
    RestResponse<List<PointsDeductionInfoRespDto>> getPointsDeductionInfoList(@PathVariable("shelfIds") String shelfIds);
}
