/**
 * @(#) IItemQueryApi.java 1.0 2018-08-22
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.item.api.cyclebuy;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemCycleReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemCycleBuyRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
 * 商品周期购服务
 *
 * @author wu.sheng
 * @date 2020/12/8 10:51
 */
@Api(tags = {"商品中心：商品周期购服务"})
@FeignClient(name = "${yundt.cube.center.item.api.name:yundt-cube-center-item}",
        contextId="com-dtyunxi-yundt-cube-center-item-api-cyclebuy-query-IItemCycleBuyQueryApi",
        path = "/v1/item",
        url = "${yundt.cube.center.item.api:}")
public interface IItemCycleBuyQueryApi {

    @GetMapping(value = "/cycle/{shopId}/{itemId}")
    @ApiOperation(value = "查询店铺商品的周期购信息", notes = "查询店铺商品的周期购信息")
    RestResponse<List<ItemCycleBuyRespDto>> queryItemCycleBuy(@PathVariable("shopId") Long shopId, @PathVariable("itemId") Long itemId);

    @PostMapping(value = "/cycle/batchQueryCycle")
    @ApiOperation(value = "批量查询店铺商品的周期购信息", notes = "批量店铺商品的周期购信息")
    RestResponse<List<ItemCycleBuyRespDto>> batchQueryItemCycleBuy(@RequestBody List<ItemCycleReqDto> itemCycleReqDtos);
}
