package com.dtyunxi.yundt.cube.center.item.api;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.item.api.dto.request.ItemExtendImportDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.request.ItemExtendReqDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;

import java.util.List;

/**
 * 商品扩展参数表服务接口
 *
 * @author yuangui
 * @since 2022-05-11
 */
@Api(tags = {"商品扩展参数表服务"})
@FeignClient(
        contextId = "com-yx-tcbj-center-api-IItemExtendApi",
        name = "${yundt.cube.center.item.api.name:yundt-cube-center-item}",
        path = "/v1/itemExtend",
        url = "${yundt.cube.center.item.api:}"
)
public interface IItemExtendApi {

    /**
     * 新增商品扩展参数表
     *
     * @param addReqDto 商品扩展参数表请求对象
     * @return 处理结果
     */
    @PostMapping("")
    @ApiOperation(value = "新增商品扩展参数表", notes = "新增商品扩展参数表")
    RestResponse<Long> addItemExtend(@RequestBody ItemExtendReqDto addReqDto);

    /**
     * 批量新增商品扩展参数表
     *
     * @param addReqDto 商品扩展参数表请求对象
     * @return 处理结果
     */
    @PostMapping("/save/batch")
    @ApiOperation(value = "批量新增商品扩展参数表", notes = "批量新增商品扩展参数表")
    RestResponse<Void> addItemExtendBatch(@RequestBody List<ItemExtendReqDto> addReqDto);

    /**
     * 导入更新商品扩展数据
     *
     * @param updateDto 商品扩展参数表请求对象
     * @return 处理结果
     */
    @PostMapping("/update/importData")
    @ApiOperation(value = "导入更新商品扩展数据", notes = "导入更新商品扩展数据")
    RestResponse<Void> updateImportData(@RequestBody List<ItemExtendImportDto> updateDto);

    /**
     * 修改商品扩展参数表
     *
     * @param modifyReqDto 商品扩展参数表请求对象
     * @return 处理结果
     */
    @PutMapping("")
    @ApiOperation(value = "修改商品扩展参数表", notes = "修改商品扩展参数表")
    RestResponse<Void> modifyItemExtend(@RequestBody ItemExtendReqDto modifyReqDto);

    @PutMapping("/modifyPrice")
    @ApiOperation(value = "修改商品推荐价格", notes = "修改商品推荐价格")
    RestResponse<Void> modifyPrice(@RequestBody ItemExtendReqDto modifyReqDto);

    /**
     * 删除商品扩展参数表
     *
     * @param ids        商品扩展参数表删除数据ID
     * @param instanceId 实例ID
     * @return 处理结果
     */
    @DeleteMapping("/{ids}")
    @ApiOperation(value = "删除商品扩展参数表", notes = "删除商品扩展参数表")
    RestResponse<Void> removeItemExtend(@PathVariable("ids") String ids, @RequestParam("instanceId") Long instanceId);
}
