/**
 * @(#) IStorageApi.java 1.0 2018-11-30
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.item.api.base;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.BatchItemStorageReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemStorageReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemStorageReturnReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemStorageSubReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.BatchItemStorageRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * 商品库存接口服务
 *
 * @author 魄罗
 * @since 2.0.0
 */
@Api(tags = {"商品中心：商品库存接口服务"})
@FeignClient(name = "${yundt.cube.center.item.api.name:yundt-cube-center-item}",
        contextId = "com-dtyunxi-yundt-cube-center-item-api-base-IItemStorageApi",
        path = "/v1/item/storage",
        url = "${yundt.cube.center.item.api:}")
public interface IItemStorageApi {

    /**
     * 操作商品库存
     *
     * @param itemStorageReqDto 业务请求参数
     * @return 操作结果
     */
    @PostMapping("")
    @ApiOperation(value = "新增/扣减商品库存", notes = "新增/扣减商品库存(balance大于0为新增，PS：balance为增量值不为库存总值;balance小于0为扣减)")
    RestResponse<Long> operatingItemStorage(@RequestBody ItemStorageReqDto itemStorageReqDto);
    /**
     * 批量操作商品库存
     *
     * @param batchItemStorageReqDto 业务请求参数
     * @return 成功的操作库存的商品列表
     */
    @PostMapping("/batch")
    @ApiOperation(value = "新增/扣减商品库存", notes = "新增/扣减商品库存(balance大于0为新增，PS：balance为增量值不为库存总值;balance小于0为扣减)")
    RestResponse<BatchItemStorageRespDto> batchOperatingItemStorage(@RequestBody BatchItemStorageReqDto batchItemStorageReqDto);
    /**
     * 预占商品库存
     * 1.写一条库存变更数据
     * 2.发送mq
     * 3.自己监听发送的mq并同步数据到库存表
     *
     * @param itemStorageSubReqDto 要扣减商品库存信息
     * @return 操作结果
     */
    @PutMapping("")
    @ApiOperation(value = "预占商品库存(下订单时使用),已经废弃，只用新增和扣减", notes = "预占商品库存(下订单时使用),已经废弃，只用新增和扣减")
    @Deprecated
    RestResponse<Void> subItemStorage(@RequestBody ItemStorageSubReqDto itemStorageSubReqDto);

    /**
     * 虚拟商品库存回退
     *
     * @param itemStorageReturnReqDto 要回退的商品库存信息
     * @return 操作结果
     */
    @PutMapping("/return")
    @ApiOperation(value = "虚拟商品库存回退", notes = "虚拟商品库存回退")
    RestResponse<Void> returnItemStorage(@RequestBody ItemStorageReturnReqDto itemStorageReturnReqDto);
}
