/**
 * @(#)IPropApi 1.0 2018-11-29
 * <p>
 * Copyright (c) 2016, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.item.api.base;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.*;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * 属性管理接口
 *
 * @author 双清
 */
@Api(tags = {"商品中心：属性服务"})
@FeignClient(name = "${yundt.cube.center.item.api.name:yundt-cube-center-item}",
        contextId = "com-dtyunxi-yundt-cube-center-item-api-base-IPropApi",
        path = "/v1/prop",
        url = "${yundt.cube.center.item.api:}")
public interface IPropApi {

    /**
     * 新增属性
     *
     * @param propNameCreateReqDto 属性名请求入参
     * @return 返回属性ID
     */
    @PostMapping(value = "", produces = "application/json")
    @ApiOperation(value = "新增属性", notes = "新增属性")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "propNameCreateReqDto", value = "属性请求入参dto", dataType = "PropNameCreateReqDto", paramType = "body")
    })
    RestResponse<Long> addProp(@Validated @RequestBody PropNameCreateReqDto propNameCreateReqDto);

    /**
     * 批量新增属性
     *
     * @param propNameCreateReqDtoList 属性请求入参列表
     * @return
     */
    @PostMapping(value = "/propName/batch", produces = "application/json")
    @ApiOperation(value = "批量新增属性", produces = "批量新增属性")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "propNameCreateReqDtoList", value = "属性请求入参列表", dataType = "PropNameCreateReqDto", paramType = "body", allowMultiple = true)
    })
    RestResponse<Void> batchAddProp(@Validated @RequestBody List<PropNameCreateReqDto> propNameCreateReqDtoList);

    /**
     * 新增属性组
     *
     * @param propGroupReqDto 属性组请求入参
     * @return 返回属性组ID
     */
    @PostMapping(value = "/propGroup", produces = "application/json")
    @ApiOperation(value = "新增属性组", notes = "新增属性组")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "propGroupReqDto", value = "属性组请求入参dto", dataType = "PropGroupReqDto", paramType = "body")
    })
    RestResponse<Long> addPropGroup(@Validated @RequestBody PropGroupReqDto propGroupReqDto);

    /**
     * 批量新增属性组
     *
     * @param propGroupReqDtoList 属性组请求入参列表
     * @return
     */
    @PostMapping(value = "/propGroup/batch", produces = "application/json")
    @ApiOperation(value = "批量新增属性组", notes = "批量新增属性组")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "propGroupReqDtoList", value = "属性组请求入参列表", dataType = "PropGroupReqDto", paramType = "body", allowMultiple = true)
    })
    RestResponse<Void> batchAddPropGroup(@Validated @RequestBody List<PropGroupReqDto> propGroupReqDtoList);

    /**
     * 修改属性
     *
     * @param propNameReqDto 属性名请求入参
     * @return
     */
    @PutMapping(value = "", produces = "application/json")
    @ApiOperation(value = "根据主键ID修改属性", notes = "根据主键ID修改属性")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "propNameReqDto", value = "属性请求入参dto", dataType = "PropNameReqDto", paramType = "body")
    })
    RestResponse<Void> modifyProp(@Validated @RequestBody PropNameReqDto propNameReqDto);

    /**
     * 修改属性组
     *
     * @param propGroupReqDto 属性组请求入参
     * @return
     */
    @PutMapping(value = "/propGroup", produces = "application/json")
    @ApiOperation(value = "根据主键ID修改属性组", notes = "根据主键ID修改属性组")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "propGroupReqDto", value = "属性组请求入参dto", dataType = "PropGroupReqDto", paramType = "body")
    })
    RestResponse<Void> modifyPropGroup(@Validated @RequestBody PropGroupReqDto propGroupReqDto);

    /**
     * 根据主键ID删除属性
     *
     * @param id 属性名主键id
     * @return
     */
    @DeleteMapping(value = "/{id}", produces = "application/json")
    @ApiOperation(value = "根据主键ID删除属性", notes = "根据主键ID删除属性")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "属性名主键ID", dataType = "Long", paramType = "path")
    })
    RestResponse<Void> removeProp(@PathVariable("id") Long id);

    /**
     * 根据主键ID删除属性组
     *
     * @param id 属性组主键id
     * @return
     */
    @DeleteMapping(value = "/propGroup/{id}", produces = "application/json")
    @ApiOperation(value = "根据主键ID删除属性组", notes = "根据主键ID删除属性组")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "属性组主键ID", dataType = "Long", paramType = "path")
    })
    RestResponse<Void> removePropGroup(@PathVariable("id") Long id);

    /**
     * 批量添加目录属性关系
     *
     * @param dirPropRelationReqDtos 目录属性请求入参
     * @return
     */
    @PostMapping(value = "/dir/prop/relation", produces = "application/json")
    @ApiOperation(value = "批量添加目录属性", notes = "批量添加目录属性")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "dirPropRelationReqDtos", value = "目录属性请求入参", dataType = "DirPropRelationReqDto", paramType = "body", allowMultiple = true)
    })
    RestResponse<Void> addDirPropRelation(@Validated @RequestBody List<DirPropRelationReqDto> dirPropRelationReqDtos);

    /**
     * 通过dirIds列表删除目录属性关系
     *
     * @param dirIds 目录属性关联Id列表
     * @return
     */
    @DeleteMapping(value = "/dir/prop/relation", produces = "application/json")
    @ApiOperation(value = "通过目录id列表删除目录属性关系", notes = "通过目录id列表删除目录属性关系")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "dirIds", value = "目录属性关联Id列表,逗号分隔", dataType = "String", paramType = "query")
    })
    RestResponse<Void> removeDirPropRelation(@NotNull @RequestParam(name = "dirIds") String dirIds);

    /**
     * 批量修改目录属性关系(会删除dirId的关联关系，再写新数据)
     *
     * @param dirId                  目录id
     * @param dirPropRelationReqDtos 目录属性请求dto
     * @return
     */
    @PutMapping(value = "/dir/prop/relation/{dirId}", produces = "application/json")
    @ApiOperation(value = "批量修改目录属性关系(会删除dirId的关联关系，再写新数据)", notes = "批量修改目录属性关系(会删除dirId的关联关系，再写新数据)")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "dirId", value = "目录id", dataType = "Long", paramType = "path"),
            @ApiImplicitParam(name = "dirPropRelationReqDtos", value = "批量修改目录属性关系", dataType = "DirPropRelationReqDto", paramType = "body", allowMultiple = true)
    })
    RestResponse<Void> modifyDirPropRelation(@PathVariable(name = "dirId") Long dirId, @Validated @RequestBody List<DirPropRelationReqDto> dirPropRelationReqDtos);

    /**
     * 批量修改目录属性关系(在原来的数据上面修改)
     *
     * @param dirPropRelationModifyReqDtoList 批量修改数据
     * @return 操作结果
     */
    @PutMapping("/dir/prop/relation")
    @ApiOperation(value = "批量修改目录属性关系(在原来的数据上面修改)", notes = "批量修改目录属性关系(在原来的数据上面修改)")
    RestResponse<Void> modifyDirPropRelation(@RequestBody List<DirPropRelationModifyReqDto> dirPropRelationModifyReqDtoList);

    /**
     * 解析批量导入的属性excel文件
     *
     * @param file excel文件
     * @return
     */
    @PostMapping(value = "/add/excel")
    @ApiOperation(value = "通过excel批量导入属性名", notes = "通过excel批量导入属性名")
    RestResponse<Void> addPropNameByExcel(@RequestParam("file") MultipartFile file);
}