package com.dtyunxi.yundt.cube.center.item.api.base;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.UnitReqDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.validation.constraints.NotNull;

/**
 * @author yufan
 * @time 2020/10/15 10:47
 */
@Api(tags = {"商品中心：单位服务"})
@FeignClient(name = "${yundt.cube.center.item.api.name:yundt-cube-center-item}",
        contextId = "com-dtyunxi-yundt-cube-center-item-api-base-IUnitApi",
        path = "/v1/unit",
        url = "${yundt.cube.center.item.api:}")
public interface IUnitApi {

    /**
     * 新增单位
     *
     * @param reqDto 单位实体对象
     * @return 统一返回响应对象，业务数据data为新增后的单位Id
     */
    @PostMapping("")
    @ApiOperation(value = "新增单位", notes = "新增单位")
    RestResponse<Long> addUnit(@Validated @RequestBody UnitReqDto reqDto);

    /**
     * 更新单位
     *
     * @param reqDto 单位实体对象
     * @return Void
     */
    @PutMapping("")
    @ApiOperation(value = "更新单位", notes = "更新单位")
    RestResponse<Void> modifyUnit(@Validated @RequestBody UnitReqDto reqDto);

    /**
     * 更新单位状态
     *
     * @param id     单位Id
     * @param status 状态
     * @return 统一返回响应对象，业务数据data为更新后的单位Id
     */
    @PutMapping(value = "/{id}/status/{status}")
    @ApiOperation(value = "更新单位状态", notes = "更新单位状态 \n id:单位id status:状态(0禁用 1启用)")
    RestResponse<Void> modifyStatus(@NotNull(message = "单位Id不能为空") @PathVariable("id") Long id,
                                    @NotNull(message = "要修改不能为空") @PathVariable("status") Integer status);

    /**
     * 删除单位
     *
     * @param ids 单位Id
     * @return Void
     */
    @DeleteMapping(value = "/{ids}")
    @ApiOperation(value = "删除单位", notes = "根据单位Id删除单位信息 \t\n id:单位Id，复数用逗号隔开")
    RestResponse<Void> removeById(@NotNull(message = "单位Id不能为空") @PathVariable("ids") String ids);
}
