package com.dtyunxi.yundt.cube.center.item.api.base.constants;

/**
 * 商品周期购配送类型
 */
public enum CycleBuyDeliveryTypeEnum {

    BY_DAY(0, "按天"),
    BY_WEEK(1, "按周"),
    BY_MONTH(2, "按月");

    private int code;

    private String name;

    CycleBuyDeliveryTypeEnum(int code, String name) {
        this.code = code;
        this.name = name;
    }

    public static CycleBuyDeliveryTypeEnum getByCode(int code) {
        for (CycleBuyDeliveryTypeEnum data : CycleBuyDeliveryTypeEnum.values()) {
            if (code == data.getCode()) {
                return data;
            }
        }
        return null;
    }

    public int getCode() {
        return code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
}
