package com.dtyunxi.yundt.cube.center.item.api.base.constants;

/**
 * 代表选择的范围
 * @author sumo
 * @date 2020/11/11 0011
 */
public enum RangeTypeEnum {
    /**
     * 代表选择的范围
     */
    PART(0, "部分"),
    ALL(1, "所有"),
    ZERO(3, "没有");

    ;

    private final Integer code;
    private final String name;

    RangeTypeEnum(Integer code, String name) {
        this.code = code;
        this.name = name;
    }

    public Integer getCode() {
        return code;
    }

    public String getName() {
        return name;
    }


    public static RangeTypeEnum fromCode(Integer status) {
        for (RangeTypeEnum typeEnum : RangeTypeEnum.values()) {
            if (typeEnum.getCode().equals(status)) {
                return typeEnum;
            }
        }
        return null;
    }

    public static Integer toCode(Integer status) {
        RangeTypeEnum newEnum = fromCode(status);
        return newEnum == null ? null : newEnum.getCode();
    }

    public static String toName(Integer status) {
        RangeTypeEnum newEnum = fromCode(status);
        return newEnum == null ? null : newEnum.getName();
    }
}
