/**
 * @(#) IExampleService.java 1.1.0 2018-08-20
 * <p>
 * Copyright (c)  2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.item.api.base.dto;

import com.dtyunxi.vo.BaseVo;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;

/**
 * 商品dto
 *
 * @author 佐助
 * @since 2.0.0
 */
public class ItemDto extends BaseVo {

    @ApiModelProperty(name = "id", value = "id")
    private Long id;
    /**
     * 名称
     */
    @NotNull
    @ApiModelProperty(name = "name", value = "编码")
    private String name;

    /**
     * 显示名
     */
    @ApiModelProperty(name = "displayName", value = "显示名")
    private String displayName;

    /**
     * 编码
     */
    @NotNull
    @ApiModelProperty(name = "code", value = "编码")
    private String code;

    /**
     * 品牌名称
     */
    @ApiModelProperty(name = "brand", value = "品牌名称")
    private String brand;

    /**
     * 品牌Id
     */
    @ApiModelProperty(name = "brand_id", value = "品牌id")
    private Long brandId;
    /**
     * 虚拟商品
     */
    @ApiModelProperty(name = "vitrual", value = "虚拟商品")
    private Boolean vitrual;

    /**
     * 简介
     */
    @ApiModelProperty(name = "brief", value = "简介")
    private String brief;

    /**
     * 状态
     */
    @ApiModelProperty(name = "status", value = "状态")
    private Integer status;

    /**
     * 商品类型: 1-商品  2-产品  默认1 3 -组合商品；
     */
    @ApiModelProperty(name = "type", value = "商品类型:1-商品  2-产品  默认1 3 -组合商品；")
    private Integer type;

    /**
     * 产品id
     */
    @ApiModelProperty(name = "spuId", value = "产品id")
    private Long spuid;

    /**
     * 应用实例ID
     */
    @ApiModelProperty(name = "instanceId", value = "应用实例ID")
    private Long instanceId;

    /**
     * 创建人
     */
    @ApiModelProperty(name = "ownerId", value = "创建人")
    private Long ownerId;

    /**
     * 商品版本
     */
    @ApiModelProperty(name = "version", value = "商品版本")
    private Long version;

    /**
     * 编码
     */
    @ApiModelProperty(name = "detail", value = "详情")
    private String detail;


    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDisplayName() {
        return displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getBrand() {
        return brand;
    }

    public void setBrand(String brand) {
        this.brand = brand;
    }

    public Boolean getVitrual() {
        return vitrual;
    }

    public void setVitrual(Boolean vitrual) {
        this.vitrual = vitrual;
    }

    public String getBrief() {
        return brief;
    }

    public void setBrief(String brief) {
        this.brief = brief;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public Long getSpuid() {
        return spuid;
    }

    public void setSpuid(Long spuid) {
        this.spuid = spuid;
    }

    public Long getInstanceId() {
        return instanceId;
    }

    public void setInstanceId(Long instanceId) {
        this.instanceId = instanceId;
    }

    public Long getOwnerId() {
        return ownerId;
    }

    public void setOwnerId(Long ownerId) {
        this.ownerId = ownerId;
    }

    public Long getVersion() {
        return version;
    }

    public void setVersion(Long version) {
        this.version = version;
    }

    public String getDetail() {
        return detail;
    }

    public void setDetail(String detail) {
        this.detail = detail;
    }

    public Long getBrandId() {
        return brandId;
    }

    public void setBrandId(Long brandId) {
        this.brandId = brandId;
    }
}
