/*
 * @(#)InventoryException.java 1.0 2018-08-22
 *
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.item.api.base.dto.request;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;

/**
 * 商品组合请求参数Dto
 * <p>
 * /**
 * 商品组合请求Dto
 *
 * @author 佐助
 * @since 2.0.0
 */
@ApiModel(value = "BundleItemReqDto", description = "商品组合请求参数Dto")
public class BundleItemReqDto extends BaseReqDto {

    @ApiModelProperty(name = "id", value = "主键id，不填")
    private Long id;

    @ApiModelProperty(name = "itemId", value = "商品ID，必填")
    private Long itemId;

    @ApiModelProperty(name = "skuId", value = "规格ID，必填")
    private Long skuId;

    @ApiModelProperty(name = "subItemId", value = "子商品ID，必填")
    private Long subItemId;

    @ApiModelProperty(name = "subItemName", value = "子商品名称")
    private String subItemName;

    @ApiModelProperty(name = "subSkuId", value = "子商品skuID，必填")
    private Long subSkuId;

    @ApiModelProperty(name = "subSkuCode", value = "子商品skuCode，必填")
    private String subSkuCode;

    @ApiModelProperty(name = "attr", value = "属性")
    private String attr;

    @ApiModelProperty(name = "cargoCode", value = "货品编码")
    private String cargoCode;

    @ApiModelProperty(name = "barCode", value = "识别码，选填")
    private String barCode;

    @ApiModelProperty(name = "price", value = "价格(划线价)")
    private BigDecimal price;

    @ApiModelProperty(name = "retailPrice", value = "零售价")
    private BigDecimal retailPrice;

    @ApiModelProperty(name = "storage", value = "安全库存数")
    private Integer safetyStock;

    @ApiModelProperty(name = "shelf_amount", value = "可卖数量")
    private Long shelfAmount;

    @ApiModelProperty(name = "num", value = "组合基数，选填")
    private Integer num;

    @ApiModelProperty(name = "shelfStatus", value = "上架状态")
    private Integer shelfStatus;

    public String getAttr() {
        return attr;
    }

    public void setAttr(String attr) {
        this.attr = attr;
    }

    public Integer getShelfStatus() {
        return shelfStatus;
    }


    public Long getShelfAmount() {
        return shelfAmount;
    }

    public void setShelfAmount(Long shelfAmount) {
        this.shelfAmount = shelfAmount;
    }

    public void setShelfStatus(Integer shelfStatus) {
        this.shelfStatus = shelfStatus;
    }

    public Integer getSafetyStock() {
        return safetyStock;
    }

    public void setSafetyStock(Integer safetyStock) {
        this.safetyStock = safetyStock;
    }

    public String getSubItemName() {
        return subItemName;
    }

    public void setSubItemName(String subItemName) {
        this.subItemName = subItemName;
    }

    public BigDecimal getPrice() {
        return price;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }

    public BigDecimal getRetailPrice() {
        return retailPrice;
    }

    public void setRetailPrice(BigDecimal retailPrice) {
        this.retailPrice = retailPrice;
    }

    public String getSubSkuCode() {
        return subSkuCode;
    }

    public void setSubSkuCode(String subSkuCode) {
        this.subSkuCode = subSkuCode;
    }

    public String getCargoCode() {
        return cargoCode;
    }

    public void setCargoCode(String cargoCode) {
        this.cargoCode = cargoCode;
    }

    public String getBarCode() {
        return barCode;
    }

    public void setBarCode(String barCode) {
        this.barCode = barCode;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getItemId() {
        return itemId;
    }

    public void setItemId(Long itemId) {
        this.itemId = itemId;
    }

    public Long getSkuId() {
        return skuId;
    }

    public void setSkuId(Long skuId) {
        this.skuId = skuId;
    }

    public Long getSubItemId() {
        return subItemId;
    }

    public void setSubItemId(Long subItemId) {
        this.subItemId = subItemId;
    }

    public Long getSubSkuId() {
        return subSkuId;
    }

    public void setSubSkuId(Long subSkuId) {
        this.subSkuId = subSkuId;
    }


    public Integer getNum() {
        return num;
    }

    public void setNum(Integer num) {
        this.num = num;
    }
}