/**
 * @(#)UserExceptionCode.java 1.0 2016-11-10
 * <p>
 * Copyright (c) 2017, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.item.api.base.exception;

/**
 * 描述
 *
 * @author 管春
 * @since 0.6.0
 */
public enum ItemExceptionCode {
    NON_EXIST_PARAM("10009", "参数不能为空"),
    EMPTY_PARAM_ERROR("10010", "参数错误，请检查参数"),
    NON_EXIST_ITEM("10011", "商品不存在"),
    NON_EXIST_BRAND("10012", "商品品牌不存在"),
    EXIST_BRAND("10013", "商品品牌已经存在"),
    NON_EXIST_TAG("10014", "标签不存在"),
    EXIST_TAG("10015", "标签已经存在"),
    NON_EXIST_VERSION("10016", "查询不到此版本记录"),
    NON_EXIST_SKU("10017", "查询不到商品sku"),
    NON_EXIST_DIR("10018", "查询不到目录"),
    EXIST_DIR("10019", "目录已经存在"),
    UPDATE_EXIST_DIR("10020", "要更改目录名已存在"),
    CODE_EXIST("10021", "目录编码已存在"),
    EXIST_DIR_CHILD("10022", "存在子目录，请先操作子目录"),
    PUBLISH_NOT_ALLOWED("10023", "商品已上架，无法再次发布"),
    RECORD_NOT_EXIST("10024", "记录不存在"),
    BRAND_CODE_EXISTS("10025", "品牌编码已存在"),
    LINK_NOT_EXISTS("10026", "引用目录ID(link)不存在"),
    TIME_FORMAT_ERROR("10027", "错误的时间格式(格式为yyyy-MM-dd HH:mm:ss)"),
    STORAGE_NOT_ENOUGH("10028", "商品库存不足"),
    STORAGE_OPERATING_ERROR("10029", "商品库存操作失败"),
    ORDER_EXISTS("10030", "交易订单号已存在"),
    ITEM_OFF_SHELF("10031", "商品未上架"),
    NON_EXIST_PROPNAME("10028", "属性名不存在"),
    NON_EXIST_PROPGROUP("10029", "属性组不存在"),
    NON_EXIST_DIRPROP("10030", "目录属性不存在"),
    PROPTYPE_ERROR("10031", "属性类型不正确"),
    NON_EXIST_QUERY_SKU("10032", "skuId不允许为空"),
    NAME_EXISTS("10033", "名称已经存在"),
    NAME_NULL("10034", "名称不允许为空"),
    CODE_EXISTS("10035", "编码已经存在"),
    TASK_EXISTS("10036", "该商品已有同一时间的上架任务"),
    RELATION_EXISTS("10037", "存在关联关系"),
    ORDER_NOT_EXISTS("10038", "交易订单号不存在"),
    SKU_CODE_EXISTS("10039", "sku编码已存在"),
    BRAND_REFERENCED_BY_ITEM("10040", "品牌已被引用,不可删除"),
    ITEM_CODE_EXISTS("10041", "商品编码已存在");


    private final String code;

    private final String msg;


    private ItemExceptionCode(String val, String info) {
        this.code = val;
        this.msg = info;

    }

    public String getCode() {
        return code;
    }

    public String getMsg() {
        return msg;

    }

    public static String getDesc(String index) {
        for (ItemExceptionCode exceptionCode : ItemExceptionCode.values()) {
            if (exceptionCode.getCode().equals(index)) {
                return exceptionCode.getMsg();
            }
        }
        return null;
    }

}
