package com.dtyunxi.yundt.cube.center.item.api.dto;


import com.dtyunxi.dto.BaseRespDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.DecimalMax;
import javax.validation.constraints.Size;
import java.math.BigDecimal;

/**
 * 商品开票信息对象ItemInvoiceDto
 *
 * @author yiyun
 * @since 2021-10-07
 */
@ApiModel(value = "ItemInvoiceDto", description = "商品开票信息对象ItemInvoiceDto")
@Data
public class ItemInvoiceDto extends BaseRespDto {
    /*
     * 专利名称
     * */
    @ApiModelProperty(value = "patentName",name = "专利名称")
    @Size(max = 80)
    private String patentName;
    /*
     * 税率
     * */
    @ApiModelProperty(value = "taxRate",name = "税率")
    @DecimalMax(value = "1")
    private BigDecimal taxRate;
    /*
     * 税收分类编码
     * */
    @ApiModelProperty(value = "taxCategoryCode",name = "税收分类编码")
    @Size(max = 19)
    private String taxCategoryCode;
    /*
    * 商品名称
    * */
    @ApiModelProperty(value = "ItemName",name = "商品名称")
    private String ItemName;
    /*
    * 商品简称
    * */
    @ApiModelProperty(value = "ItemDisplayName",name = "商品简称")
    private String ItemDisplayName;
    /*
     * 商品编码
     * */
    @ApiModelProperty(value = "itemCode",name = "商品编码")
    private String itemCode;
    /*
     * 商品类别
     * */
    @ApiModelProperty(value = "itemType",name = "商品类别")
    private String itemType;

    /*
     * 计量单位
     * */
    @ApiModelProperty(value = "calcuUnit",name = "计量单位")
    private String calcuUnit;

    /*
     * 规格型号
     * */
    @ApiModelProperty(value = "specification",name = "规格型号")
    private String specification;

}
