/*
 * @(#)CollectionQueryReqDto.java 1.0 2021年10月08日
 *
 *  Copyright (c) 2016, YUNXI. All rights reserved.
 *  YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.dtyunxi.yundt.cube.center.item.api.dto.request;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;

/**
 * <p>Title:CollectionQueryReqDto</p>
 * <p>Description: </p>
 *
 * @author yiyun.lkh
 * @date 2021/10/8 21:17
 * @since 0.1.0
 */
@ApiModel(value = "CollectionQueryReqDto", description = "CollectionQueryReqDto对象")
public class CollectionQueryReqDto implements Serializable {

    @ApiModelProperty(
            name = "search",
            value = "查询条件"
    )
    private String search;
    @ApiModelProperty(
            name = "pageNum",
            value = "当前页"
    )
    private Integer pageNum;
    @ApiModelProperty(
            name = "pageSize",
            value = "每页数"
    )
    private Integer pageSize;

    @ApiModelProperty(
            name = "shopId",
            value = "店铺id"
    )
    private Long shopId;

    @ApiModelProperty(
            name = "customerId",
            value = "客户id"
    )
    private Long customerId;

    @ApiModelProperty(name = "customerId",value = "客户id")
    private String customerCode;

    @ApiModelProperty(name = "userId", value = "商城业务员登录后，选择经销商后返回的userId")
    private Long userId;
    @ApiModelProperty(name = "customerType", value = "客户类型")
    private Integer customerType;
    @ApiModelProperty(name = "isGroupBuy", value = "是否选择团购")
    private Boolean isGroupBuy;
    @ApiModelProperty(name = "priceIdentify", value = "价格标识(0:国内价格标识,1:国外价格标识)")
    private String priceIdentify;
    @ApiModelProperty(
            name = "currency",
            value = "币种,0:人民币 1:美元 2:日元 3:欧元 4:英镑 5:澳元 6:港元 7:澳门元"
    )
    private Integer currency;
    @ApiModelProperty(name = "shelfAddress", value = "上架地址(0:国内B2B商城,1:国外B2B商城)")
    private String shelfAddress;

    public String getSearch() {
        return search;
    }

    public void setSearch(String search) {
        this.search = search;
    }

    public Integer getPageNum() {
        return pageNum;
    }

    public void setPageNum(Integer pageNum) {
        this.pageNum = pageNum;
    }

    public Integer getPageSize() {
        return pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public Long getShopId() {
        return shopId;
    }

    public void setShopId(Long shopId) {
        this.shopId = shopId;
    }

    public Long getCustomerId() {
        return customerId;
    }

    public void setCustomerId(Long customerId) {
        this.customerId = customerId;
    }

    public Long getUserId() {
        return userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public Integer getCustomerType() {
        return customerType;
    }

    public void setCustomerType(Integer customerType) {
        this.customerType = customerType;
    }

    public Boolean getGroupBuy() {
        return isGroupBuy;
    }

    public void setGroupBuy(Boolean groupBuy) {
        isGroupBuy = groupBuy;
    }

    public String getCustomerCode() {
        return customerCode;
    }

    public void setCustomerCode(String customerCode) {
        this.customerCode = customerCode;
    }

    public String getPriceIdentify() {
        return priceIdentify;
    }

    public void setPriceIdentify(String priceIdentify) {
        this.priceIdentify = priceIdentify;
    }

    public String getShelfAddress() {
        return shelfAddress;
    }

    public void setShelfAddress(String shelfAddress) {
        this.shelfAddress = shelfAddress;
    }

    public Integer getCurrency() {
        return currency;
    }

    public void setCurrency(Integer currency) {
        this.currency = currency;
    }
}
