/*
 * @(#)ItemBundlesExcelReqDto.java 1.0 2021年11月18日
 *
 *  Copyright (c) 2016, YUNXI. All rights reserved.
 *  YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.dtyunxi.yundt.cube.center.item.api.dto.request;

import cn.afterturn.easypoi.excel.annotation.Excel;
import com.dtyunxi.dto.RequestDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.List;

/**
 * <p>Title:ItemBundlesExcelReqDto</p>
 * <p>Description: </p>
 *
 * @author yiyun.lkh
 * @date 2021/11/18 19:14
 * @since 0.1.0
 */
@ApiModel(value = "ItemBundlesExcelReqDto", description = "组合商品Excel对象")
public class ItemBundlesExcelReqDto extends RequestDto {

    @ApiModelProperty(name = "id", value = "")
    private Long id;

    @ApiModelProperty(name = "itemId", value = "商品ID")
    private Long itemId;

    @ApiModelProperty(name = "skuId", value = "")
    private Long skuId;

    @Excel(name = "组合商品编码(同一个组合商品名称和编码唯一)")
    @ApiModelProperty(name = "itemCode", value = "组合商品编码(同一个组合商品名称和编码唯一)")
    private String itemCode;

    @Excel(name = "组合商品名称")
    @ApiModelProperty(name = "itemName", value = "组合商品名称")
    private String itemName;

    @Excel(name = "后台类目编码")
    @ApiModelProperty(name = "dirCode", value = "后台类目编码")
    private String dirCode;

    @ApiModelProperty(name = "dirId", value = "后台类目ID")
    private Long dirId;

    @ApiModelProperty(name = "dirName", value = "后台类目名称")
    private String dirName;

    @ApiModelProperty(name = "dirPrefixId", value = "前台类目ID")
    private Long dirPrefixId;

    @ApiModelProperty(name = "dirPrefixName", value = "前台类目名称")
    private String dirPrefixName;

    @ApiModelProperty(name = "dirIds", value = "后台类目集合")
    private List<String> dirIds;

    @ApiModelProperty(name = "dirPrefixIds", value = "前台类目集合")
    private List<String> dirPrefixIds;

    @Excel(name = "商品编码")
    @ApiModelProperty(name = "subItemCode", value = "商品编码")
    private String subItemCode;

    /**
     *  子商品ID
     */
    @ApiModelProperty(name = "subItemId", value = "子商品ID")
    private Long subItemId;
    /**
     *  子商品名称
     */
    @ApiModelProperty(name = "subItemName", value = "子商品名称")
    private String subItemName;
    /**
     *
     */
    @ApiModelProperty(name = "subSkuId", value = "")
    private Long subSkuId;


    @Excel(name = "商品数量")
    @ApiModelProperty(name = "num", value = "商品数量")
    private String num;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getItemId() {
        return itemId;
    }

    public void setItemId(Long itemId) {
        this.itemId = itemId;
    }

    public Long getSkuId() {
        return skuId;
    }

    public void setSkuId(Long skuId) {
        this.skuId = skuId;
    }

    public String getItemCode() {
        return itemCode;
    }

    public void setItemCode(String itemCode) {
        this.itemCode = itemCode;
    }

    public String getItemName() {
        return itemName;
    }

    public void setItemName(String itemName) {
        this.itemName = itemName;
    }

    public String getDirCode() {
        return dirCode;
    }

    public void setDirCode(String dirCode) {
        this.dirCode = dirCode;
    }

    public Long getDirId() {
        return dirId;
    }

    public void setDirId(Long dirId) {
        this.dirId = dirId;
    }

    public String getDirName() {
        return dirName;
    }

    public void setDirName(String dirName) {
        this.dirName = dirName;
    }

    public Long getDirPrefixId() {
        return dirPrefixId;
    }

    public void setDirPrefixId(Long dirPrefixId) {
        this.dirPrefixId = dirPrefixId;
    }

    public String getDirPrefixName() {
        return dirPrefixName;
    }

    public void setDirPrefixName(String dirPrefixName) {
        this.dirPrefixName = dirPrefixName;
    }

    public List<String> getDirIds() {
        return dirIds;
    }

    public void setDirIds(List<String> dirIds) {
        this.dirIds = dirIds;
    }

    public List<String> getDirPrefixIds() {
        return dirPrefixIds;
    }

    public void setDirPrefixIds(List<String> dirPrefixIds) {
        this.dirPrefixIds = dirPrefixIds;
    }

    public String getSubItemCode() {
        return subItemCode;
    }

    public void setSubItemCode(String subItemCode) {
        this.subItemCode = subItemCode;
    }

    public Long getSubItemId() {
        return subItemId;
    }

    public void setSubItemId(Long subItemId) {
        this.subItemId = subItemId;
    }

    public String getSubItemName() {
        return subItemName;
    }

    public void setSubItemName(String subItemName) {
        this.subItemName = subItemName;
    }

    public Long getSubSkuId() {
        return subSkuId;
    }

    public void setSubSkuId(Long subSkuId) {
        this.subSkuId = subSkuId;
    }

    public String getNum() {
        return num;
    }

    public void setNum(String num) {
        this.num = num;
    }
}
