/*
 * @(#)ItemEmpowerImportReqDto.java 1.0 2021年11月30日
 *
 *  Copyright (c) 2016, YUNXI. All rights reserved.
 *  YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.dtyunxi.yundt.cube.center.item.api.dto.request;

import cn.afterturn.easypoi.excel.annotation.Excel;
import com.dtyunxi.dto.RequestDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 商品授权平台导入对象
 *
 * @author 宁毅
 * @since 2021-08-23
 */
@ApiModel(value = "ItemEmpowerImportReqDto", description = "商品授权平台导入对象")
public class ItemEmpowerImportReqDto extends RequestDto {
    /**
     * 客户名称
     */
    @ApiModelProperty(name = "customerName", value = "商品名称")
    @Excel(name = "商品名称")
    private String itemName;
    /**
     * 客户编码
     */
    @ApiModelProperty(name = "customerCode", value = "商品编码")
    @Excel(name = "商品编码")
    private String itemCode;
    /**
     *  授权平台名称
     */
    @ApiModelProperty(name = "empowerPlatformName", value = "授权平台名称")
    @Excel(name = "平台名称")
    private String platformName;
    /**
     *  授权平台编码
     */
    @ApiModelProperty(name = "empowerPlatformCode", value = "授权平台编码")
    @Excel(name = "平台编码")
    private String platformCode;

    public String getItemName() {
        return itemName;
    }

    public void setItemName(String itemName) {
        this.itemName = itemName;
    }

    public String getItemCode() {
        return itemCode;
    }

    public void setItemCode(String itemCode) {
        this.itemCode = itemCode;
    }

    public String getPlatformName() {
        return platformName;
    }

    public void setPlatformName(String platformName) {
        this.platformName = platformName;
    }

    public String getPlatformCode() {
        return platformCode;
    }

    public void setPlatformCode(String platformCode) {
        this.platformCode = platformCode;
    }
}
