/*
 * @(#)ItemQueryConditionReqDto.java 1.0 2021年09月13日
 *
 *  Copyright (c) 2016, YUNXI. All rights reserved.
 *  YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.dtyunxi.yundt.cube.center.item.api.dto.request;

import com.dtyunxi.vo.BaseVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * <p>Title:ItemInvoiceQueryConditionReqDto</p>
 * <p>Description: </p>
 *
 * @author yiyun.lkh
 * @date 2021/9/13 23:18
 * @since 0.1.0
 */
@ApiModel(value = "ItemInvoiceConditionReqDto", description = "商品开票信息查询条件dto")
@Data
public class ItemInvoiceConditionReqDto extends BaseVo {

    /*
     * 专利名称
     * */
    @ApiModelProperty(value = "patentName",name = "专利名称")
    private String patentName;
    /*
     * 税率
     * */
    @ApiModelProperty(value = "taxRate",name = "税率")
    private BigDecimal taxRate;
    /*
     * 税收分类编码
     * */
    @ApiModelProperty(value = "taxCategoryCode",name = "税收分类编码")
    private String taxCategoryCode;
    /*
     * 商品名称
     * */
    @ApiModelProperty(value = "ItemName",name = "商品名称")
    private String ItemName;
    /*
     * 商品简称
     * */
    @ApiModelProperty(value = "ItemDisplayName",name = "商品简称")
    private String ItemDisplayName;
    /*
     * 商品编码
     * */
    @ApiModelProperty(value = "itemCode",name = "商品编码")
    private String itemCode;
    /*
     * 商品类别
     * */
    @ApiModelProperty(value = "itemType",name = "商品类别")
    private String itemType;

    @ApiModelProperty(name = "updateBeginTime", value = "更新开始时间")
    private String updateBeginTime;

    @ApiModelProperty(name = "updateEndTime", value = "更新结束时间")
    private String updateEndTime;

    @ApiModelProperty(name = "createBeginTime", value = "创建开始时间")
    private String createBeginTime;

    @ApiModelProperty(name = "createEndTime", value = "创建结束时间")
    private String createEndTime;

    @ApiModelProperty(name = "pageNum", value = "当前页")
    private Integer pageNum;

    @ApiModelProperty(name = "pageSize", value = "每页数")
    private Integer pageSize;


}
