package com.dtyunxi.yundt.cube.center.item.api.dto.request;

import com.dtyunxi.yundt.cube.center.item.api.dto.base.BaseReqDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.List;

/**
 * @author 迪迦
 * @date 2021-09-26
 */
@ApiModel(value = "ItemPricePageReqDto", description = "商品价格列表请求Dto")
public class ItemPricePageReqDto extends BaseReqDto {

    /**
     *  商品显示名
     */
    @ApiModelProperty(name = "displayName", value = "商品显示名")
    private String displayName;

    /**
     *  商品编码
     */
    @ApiModelProperty(name = "itemCode", value = "商品编码")
    private String itemCode;

    /**
     *  SKU编码
     */
    @ApiModelProperty(name = "skuCode", value = "SKU编码")
    private String skuCode;

    /**
     *  商品类型
     */
    @ApiModelProperty(name = "itemType", value = "商品类型，1-产品，2-赠品，3-物料")
    private Integer subType;

    /**
     *  品牌名称
     */
    @ApiModelProperty(name = "brand", value = "品牌名称")
    private String brand;

    /**
     *  品牌ID
     */
    @ApiModelProperty(name = "brandId", value = "品牌ID")
    private String brandId;

    /**
     *  后台类目
     */
    @ApiModelProperty(name = "dir", value = "后台类目")
    private List<Long> dirIds;

    /**
     *  客户名称
     */
    @ApiModelProperty(name = "customerIds", value = "客户ids")
    private List<Long> customerIds;

    /**
     *  客户名称
     */
    @ApiModelProperty(name = "customerName", value = "客户名称")
    private String customerName;

    /**
     *  客户编码
     */
    @ApiModelProperty(name = "customerCode", value = "客户编码")
    private String customerCode;

    /**
     *  商户ID
     */
    @ApiModelProperty(name = "sellerId", value = "商户ID")
    private Long sellerId;

    /**
     *  所属店铺
     */
    @ApiModelProperty(name = "shopId", value = "所属店铺")
    private Long shopId;

    public Long getShopId() {
        return shopId;
    }

    public void setShopId(Long shopId) {
        this.shopId = shopId;
    }

    public String getDisplayName() {
        return displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getItemCode() {
        return itemCode;
    }

    public void setItemCode(String itemCode) {
        this.itemCode = itemCode;
    }

    public String getSkuCode() {
        return skuCode;
    }

    public void setSkuCode(String skuCode) {
        this.skuCode = skuCode;
    }

    public Integer getSubType() {
        return subType;
    }

    public void setSubType(Integer subType) {
        this.subType = subType;
    }

    public String getBrand() {
        return brand;
    }

    public void setBrand(String brand) {
        this.brand = brand;
    }

    public List<Long> getDirIds() {
        return dirIds;
    }

    public void setDirIds(List<Long> dirIds) {
        this.dirIds = dirIds;
    }

    public List<Long> getCustomerIds() {
        return customerIds;
    }

    public void setCustomerIds(List<Long> customerIds) {
        this.customerIds = customerIds;
    }

    public Long getSellerId() {
        return sellerId;
    }

    public void setSellerId(Long sellerId) {
        this.sellerId = sellerId;
    }

    public String getCustomerName() {
        return customerName;
    }

    public void setCustomerName(String customerName) {
        this.customerName = customerName;
    }

    public String getCustomerCode() {
        return customerCode;
    }

    public void setCustomerCode(String customerCode) {
        this.customerCode = customerCode;
    }

    public String getBrandId() {
        return brandId;
    }

    public void setBrandId(String brandId) {
        this.brandId = brandId;
    }
}
