/*
 * @(#)ItemQueryConditionReqDto.java 1.0 2021年09月13日
 *
 *  Copyright (c) 2016, YUNXI. All rights reserved.
 *  YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.dtyunxi.yundt.cube.center.item.api.dto.request;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * <p>Title:ItemQueryConditionReqDto</p>
 * <p>Description: </p>
 *
 * @author yiyun.lkh
 * @date 2021/9/13 23:18
 * @since 0.1.0
 */
@Data
@ApiModel(value = "ItemQueryConditionReqDto", description = "商品查询条件dto")
public class ItemQueryConditionReqDto implements Serializable {

    @ApiModelProperty(name = "itemControlStatus", value = "商品管控状态：YES：管控；NO：非管控")
    private String itemControlStatus;

    @ApiModelProperty(name = "itemName", value = "名称")
    private String itemName;

    @ApiModelProperty(name = "itemCode", value = "编号")
    private String itemCode;

    @ApiModelProperty(name = "name", value = "名称")
    private String name;

    @ApiModelProperty(name = "code", value = "编号")
    private String code;

    @ApiModelProperty(name = "dirId",value = "后台类目ID")
    private Long dirId;

    @ApiModelProperty(name = "backDirId",value = "后台类目ID")
    private Long backDirId;

    @ApiModelProperty(name = "dirIdList",value = "目录Id列表")
    private List dirIdList;

    @ApiModelProperty(name = "dirPrefixId",value = "前台类目ID")
    private Long dirPrefixId;

    @ApiModelProperty(name = "beginTime", value = "开始时间")
    private String beginTime;

    @ApiModelProperty(name = "updateBeginTime", value = "更新开始时间")
    private String updateBeginTime;

    @ApiModelProperty(name = "updateEndTime", value = "更新结束时间")
    private String updateEndTime;

    @ApiModelProperty(name = "createBeginTime", value = "创建开始时间")
    private String createBeginTime;

    @ApiModelProperty(name = "createEndTime", value = "创建结束时间")
    private String createEndTime;

    @ApiModelProperty(name = "endTime", value = "结束时间")
    private String endTime;


    @ApiModelProperty(
            name = "pageNum",
            value = "当前页"
    )
    private Integer pageNum;
    @ApiModelProperty(
            name = "pageSize",
            value = "每页数"
    )
    private Integer pageSize;

    @ApiModelProperty(name = "specContent", value = "规格")
    private String specContent;

    @ApiModelProperty(name = "forward", value = "新增商品选择商品库数据时使用，forward=add,新增推荐商品 forward=statistics，运费新增商品forward=expenses")
    private String forward;

    @ApiModelProperty(name = "prodLargeClass", value = "产品大类(北鼎一级品类描述)")
    private String prodLargeClass;
    @ApiModelProperty(name = "prodLargeCode", value = "产品大类编码(北鼎一级品类)")
    private String prodLargeCode;
    @ApiModelProperty(name = "prodSecClassify", value = "产品二级分类(北鼎二级品类描述)")
    private String prodSecClassify;
    @ApiModelProperty(name = "prodSecCode", value = "产品二级分类编码(北鼎二级品类)")
    private String prodSecCode;
    @ApiModelProperty(name = "prodThrClassify", value = "产品三级分类(北鼎三级品类描述)")
    private String prodThrClassify;
    @ApiModelProperty(name = "prodThrCode", value = "产品三级分类编码(北鼎三级品类)")
    private String prodThrCode;
    @ApiModelProperty(name = "prodClassCode", value = "产品型号")
    private String prodClassCode;
    @ApiModelProperty(name = "prodClassName", value = "产品名称")
    private String prodClassName;

    @ApiModelProperty(name="inclueGroupFlag", value = "是否包含组合商品0不包含、1包含")
    private String inclueGroupFlag;

    /**
     * 商品编码集合查询
     */
    @ApiModelProperty(name = "itemCodeList", value = "商品编码集合查询")
    private List<String> itemCodeList;
    /*产品型号*/
    @ApiModelProperty(name = "productModel", value = "产品型号")
    private String productModel;
    /*产品类别*/
    @ApiModelProperty(name = "itemCategory", value = "产品类别")
    private  String itemCategory;
    /**
     *  商品简称
     */
    @ApiModelProperty(name = "displayName", value = "商品简称")
    private String displayName;
    /*燃气种类*/
    @ApiModelProperty(name = "gasClass", value = "燃气种类")
    private String gasClass;
    /*销售组*/
    @ApiModelProperty(name = "saleGroups", value = "销售组")
    private List<String> saleGroups;
    /*商品类型*/
    @ApiModelProperty(name = "types", value = "商品类型,1-商品，2.产品 3组合商品 4虚拟商品 5赠品商品")
    private List<Integer> types;

    @ApiModelProperty(name = "codes", value = "商品编码集合")
    private List<String> codes;
}
