package com.dtyunxi.yundt.cube.center.item.api.dto.response;

import com.dtyunxi.dto.BaseRespDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;

@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "OmsItemRespDto", description = "货品Dto对象")
public class OmsItemRespDto extends BaseRespDto {
    /**
     *  主键ID
     */
    @ApiModelProperty(name = "id", value = "主键ID")
    private Long id;

    /**
     *  商品长编码
     */
    @ApiModelProperty(name = "longCode", value = "商品长编码")
    private String longCode;
    /**
     *  编码
     */
    @ApiModelProperty(name = "code", value = "编码")
    private String code;

    @ApiModelProperty(name = "name", value = "名称")
    private String name;

    /**
     *  1-产品 2-赠品 3-促销物料
     */
    @ApiModelProperty(name = "itemType", value = "1-产品 2-赠品 3-促销物料")
    private Long itemType;

    @ApiModelProperty(name = "productType", value = "产品类型")
    private String productType;

    @ApiModelProperty(name = "productTypeDescribe", value = "产品类型名称")
    private String productTypeDescribe;

    @ApiModelProperty(name = "productGroup", value = "商品组")
    private String productGroup;//'商品组',

    @ApiModelProperty(name = "productGroupDesc", value = "商品组描述")
    private String productGroupDesc;//'商品组',

    @ApiModelProperty(name = "specifications", value = "规格")
    private String specifications;

    @ApiModelProperty(name = "unitId", value = "基本单位")
    private Long unitId;

    @ApiModelProperty(name = "baseUnit", value = "基本单位")
    private String baseUnit;

    @ApiModelProperty(name = "saleUnit", value = "销售单位")
    private String saleUnit;

    /**
     *  长度
     */
    @ApiModelProperty(name = "length", value = "长度")
    private BigDecimal length;
    /**
     *  高度
     */
    @ApiModelProperty(name = "height", value = "高度")
    private BigDecimal height;
    /**
     *  宽度
     */
    @ApiModelProperty(name = "width", value = "宽度")
    private BigDecimal width;

    /**
     *  大包系数
     */
    @ApiModelProperty(name = "bigRatio", value = "大包系数")
    private Long bigRatio;
    /**
     *  中包系数
     */
    @ApiModelProperty(name = "middleRatio", value = "中包系数")
    private Long middleRatio;
    /**
     *  小包系数
     */
    @ApiModelProperty(name = "smallRatio", value = "小包系数")
    private Long smallRatio;

    @ApiModelProperty(name = "imeiBatchFlag", value = "是否批次管理")
    private String imeiBatchFlag;

    @ApiModelProperty(name = "imeiCodeFlag", value = "是否串码管理")
    private String imeiCodeFlag;

    /**
     *  毛重
     */
    @ApiModelProperty(name = "grossWeight", value = "毛重")
    private BigDecimal grossWeight;

    /**
     *  净重
     */
    @ApiModelProperty(name = "netWeight", value = "净重")
    private BigDecimal netWeight;

    /**
     *  重量单位
     */
    @ApiModelProperty(name = "quantityUnit", value = "重量单位")
    private String quantityUnit;

    /**
     *  保质期
     */
    @ApiModelProperty(name = "expirationDate", value = "保质期")
    private String expirationDate;

    /**
     *  保质期单位
     */
    @ApiModelProperty(name = "expirationUnit", value = "保质期单位")
    private String expirationUnit;

    @ApiModelProperty(name = "status", value = "状态")
    private Integer status;
}
