/**
 * @(#) IExampleService.java 1.1.0 2018-08-20
 * <p>
 * Copyright (c)  2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.item.api.dto.response.dg;

import com.dtyunxi.vo.BaseVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;

/**
 * 商品dto
 *
 * @author 佐助
 * @since 2.0.0
 */
@Data
@ApiModel(value = "ItemDgDto", description = "商品主数据")
public class ItemDgDto extends BaseVo {

    @ApiModelProperty(name = "id", value = "id")
    private Long id;
    /**
     * 名称
     */
    @NotNull
    @ApiModelProperty(name = "name", value = "商品编码")
    private String name;

    /**
     * 显示名
     */
    @ApiModelProperty(name = "displayName", value = "显示名(商品简称)")
    private String displayName;

    /**
     * 编码
     */
    @NotNull
    @ApiModelProperty(name = "code", value = "商品编码")
    private String code;
    /**
     * 商品长编码
     */
    @ApiModelProperty(name = "longCode", value = "商品长编码")
    private String longCode;

    /**
     * 品牌名称
     */
    @ApiModelProperty(name = "brand", value = "品牌名称")
    private String brand;

    /**
     * 品牌Id
     */
    @ApiModelProperty(name = "brand_id", value = "品牌id")
    private Long brandId;
    /**
     * 虚拟商品
     */
    @ApiModelProperty(name = "vitrual", value = "虚拟商品")
    private Boolean vitrual;

    /**
     * 简介
     */
    @ApiModelProperty(name = "brief", value = "简介")
    private String brief;

    /**
     * 状态
     */
    @ApiModelProperty(name = "status", value = "状态")
    private Integer status;

    /**
     * 商品类型: 1-商品  2-产品  默认1 3 -组合商品；
     */
    @ApiModelProperty(name = "type", value = "商品类型:1-商品  2-产品  默认1 3 -组合商品；")
    private Integer type;

    /**
     * 产品id
     */
    @ApiModelProperty(name = "spuId", value = "产品id")
    private Long spuid;

    /**
     * 应用实例ID
     */
    @ApiModelProperty(name = "instanceId", value = "应用实例ID")
    private Long instanceId;

    /**
     * 创建人
     */
    @ApiModelProperty(name = "ownerId", value = "创建人")
    private Long ownerId;

    /**
     * 商品版本
     */
    @ApiModelProperty(name = "version", value = "商品版本")
    private Long version;

    /**
     * 编码
     */
    @ApiModelProperty(name = "detail", value = "详情")
    private String detail;
    /**
     * 是否sn码管理,1-是,0-否
     */
    @ApiModelProperty(name = "isEncode", value = "是否sn码管理,1-是,0-否")
    private Integer isEncode;
    /**
     * 是否批次管控,1-是,0-否
     */
    @ApiModelProperty(name = "isBatch", value = "是否批次管控,1-是,0-否")
    private Integer isBatch;
    /**
     * 是否质保管理,1-是,0-否
     */
    @ApiModelProperty(name = "isQuality", value = "是否质保管理,1-是,0-否")
    private Integer isQuality;
    /**
     * 质保期
     */
    @ApiModelProperty(name = "quality", value = "质保期")
    private Integer quality;
    /**
     * 质保期单位
     */
    @ApiModelProperty(name = "qualityUnit", value = "质保期单位")
    private String qualityUnit;
    /**
     * 产品大类(一级品类描述)
     */
    @ApiModelProperty(name = "prodLargeClass", value = "产品大类(一级品类描述)")
    private String prodLargeClass;
    /**
     * 产品大类编码(一级品类)
     */
    @ApiModelProperty(name = "prodLargeCode", value = "产品大类编码(一级品类编码)")
    private String prodLargeCode;
    /**
     * 产品二级分类(二级品类描述)
     */
    @ApiModelProperty(name = "prodSecClassify", value = "产品二级分类(二级品类描述)")
    private String prodSecClassify;
    /**
     * 产品二级分类编码(二级品类编码)
     */
    @ApiModelProperty(name = "prodSecCode", value = "产品二级分类编码(二级品类编码)")
    private String prodSecCode;
    /**
     * 产品三级分类(三级品类描述)
     */
    @ApiModelProperty(name = "prodThrClassify", value = "产品三级分类(三级品类描述)")
    private String prodThrClassify;
    /**
     * 产品三级分类编码(三级品类编码)
     */
    @ApiModelProperty(name = "prodThrCode", value = "产品三级分类编码(三级品类编码)")
    private String prodThrCode;
    /**
     * 基本单位
     */
    @ApiModelProperty(name = "unit", value = "基本单位")
    private String unit;
    /**
     * 属性类型
     */
    @ApiModelProperty(name = "propType", value = "属性类型")
    private Integer propType;


}
