package com.dtyunxi.yundt.cube.center.item.api.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.item.api.dto.request.ItemDataQueryReqDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.request.ItemExtendReqDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.request.ItemInfoSkuReqDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.request.PcpItemQueryDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.response.*;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import com.github.pagehelper.PageInfo;

import java.util.List;

/**
* 商品扩展参数表服务接口
*
* @author yuangui
* @since 2022-05-11
*/
@Api(tags = {"商品扩展参数表服务"})
@FeignClient(
    contextId = "com-yx-tcbj-center-api-query-IItemExtendQueryApi",
    name = "${yundt.cube.center.item.api.name:yundt-cube-center-item}",
    path = "/v1/itemExtend",
    url = "${yundt.cube.center.item.api:}"
)
public interface IItemExtendQueryApi {

    /**
    * 根据id查询商品扩展参数表
    *
    * @param id 商品扩展参数表id
    * @return   商品扩展参数表数据
    */
    @GetMapping("/{id}")
    @ApiOperation(value = "根据id查询商品扩展参数表", notes = "根据id查询商品扩展参数表")
    RestResponse<ItemExtendRespDto> queryById(@PathVariable("id") Long id);

    /**
     * 商品扩展参数表数据
     * @param reqDto
     * @return
     */
    @PostMapping("/queryParam")
    @ApiOperation(value = "商品扩展参数表数据", notes = "根据filter查询条件查询商品扩展参数表数据，filter=ItemExtendReqDto")
    RestResponse<List<ItemExtendRespDto>> queryParam(@RequestBody ItemExtendReqDto reqDto);

    /**
    * 商品扩展参数表分页数据
    *
    * @param filter   商品扩展参数表查询条件
    * @param pageNum  当前页
    * @param pageSize 页大小
    * @return 商品扩展参数表分页数据
    */
    @GetMapping("/page")
    @ApiOperation(value = "商品扩展参数表分页数据", notes = "根据filter查询条件查询商品扩展参数表数据，filter=ItemExtendReqDto")
    RestResponse<PageInfo<ItemExtendRespDto>> queryByPage(@RequestParam("filter") String filter,
                                                           @RequestParam(name = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                           @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize);

    /**
     * 分页查询
     * @param queryDto
     * @return
     */
    @PostMapping(value = "/page", produces = "application/json")
    @ApiOperation(value = "分页查询", notes = "分页查询")
    RestResponse<PageInfo<OmsItemRespDto>> queryByPage(@Validated @RequestBody PcpItemQueryDto queryDto);

    /**
     * 根据id查询商品参数表
     *
     * @param id 商品扩展参数表id
     * @return   商品扩展参数表数据
     */
    @GetMapping("/detail/{id}")
    @ApiOperation(value = "根据id查询商品参数表", notes = "根据id查询商品参数表")
    RestResponse<OmsItemDetailDto> queryItemDetailById(@PathVariable("id") Long id);

    /**
     * 根据id查询商品参数表
     *
     * @param queryReqDto 商品扩展参数表id
     * @return   商品扩展参数表数据
     */
    @PostMapping("/queryItemDetailByCode")
    @ApiOperation(value = "根据queryReqDto查询商品参数表", notes = "根据queryReqDto查询商品参数表")
    RestResponse<List<OmsItemDetailDto>> queryItemDetailByCode(@Validated @RequestBody ItemDataQueryReqDto queryReqDto);


    /**
     * 查询商品价格，单位
     * @param queryReqDto 请求参数
     * @return 商品价格，单位数据
     */
    @PostMapping(value = "/queryItemData", produces = "application/json")
    @ApiOperation(value = "查询商品", notes = "查询商品")
    RestResponse<List<ItemDataQueryRespDto>> queryItemData(@Validated @RequestBody ItemDataQueryReqDto queryReqDto);

    /**
     * 批量查询商品基本单位
     * @param queryReqDto 请求参数
     * @return 商品价格，单位数据
     */
    @PostMapping(value = "/queryBaseUnitByLongCodes", produces = "application/json")
    @ApiOperation(value = "queryBaseUnitByLongCodes", notes = "批量查询商品基本单位")
    RestResponse<List<ItemBaseUnitQueryRespDto>> queryBaseUnitByLongCodes(@RequestBody ItemDataQueryReqDto queryReqDto);



    /**
     * 查询商品规格
     * @param itemInfoSkuReqDto
     * @return
     */
    @PostMapping(value = "/queryItemSkuByCode", produces = "application/json")
    @ApiOperation(value = "查询商品规格", notes = "查询商品规格")
    RestResponse<ItemInfoSkuRespDto> queryItemSkuByCode(@Validated @RequestBody ItemInfoSkuReqDto itemInfoSkuReqDto);

    @PostMapping(value = "/queryItemDataByItemCodes", produces = "application/json")
    @ApiOperation(value = "查询商品-报表", notes = "查询商品-报表")
    RestResponse<List<ItemDataQueryRespDto>> querySimpleItemDataForReportByItemCodes(@Validated @RequestBody List<String> itemCodeList);
}
