/*
 * @(#)IItemPresentApi.java 1.0 2021年09月12日
 *
 *  Copyright (c) 2016, YUNXI. All rights reserved.
 *  YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.dtyunxi.yundt.cube.center.item.api;

import com.dtyunxi.rest.RestResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * <p>Title:IItemPresentApi</p>
 * <p>Description: </p>
 *
 * @author yiyun.lkh
 * @date 2021/9/12 23:34
 * @since 0.1.0
 */
@Api(tags = {"商品中心：赠品管理服务"})
@FeignClient(
        contextId = "com-dtyunxi-yundt-cube-center-item-api-IItemPresentApi",
        name = "${yundt.cube.center.item.api.name:yundt-cube-center-item}",
        path = "/v1/present/item",
        url = "${yundt.cube.center.item.api:}"
)
public interface IItemPresentApi {


    /**
     * 设置商品为赠品
     * @param itemIds
     * @return
     */
    @PutMapping({"/putUpPresent"})
    @ApiOperation(
            value = "设置商品为赠品",
            notes = "设置商品为赠品,itemIds支持传复数"
    )
    RestResponse<Void> putUpPresent(@RequestBody List<Long> itemIds);


    /**
     * 删除赠品
     * @param itemId
     * @return
     */
    @DeleteMapping({"/deletePresent"})
    @ApiOperation(
            value = "删除赠品",
            notes = "删除赠品"
    )
    RestResponse<Long> deletePresent(@RequestParam("itemId") Long itemId);

}
