package com.dtyunxi.yundt.cube.center.item.api;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.item.api.dto.request.ItemUnitConversionReqDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
* 商品规格换算表服务接口
*
* @author author
* @since 2022-08-28
*/
@Api(tags = {"商品规格换算表服务"})
@FeignClient(name = "${yundt.cube.center.item.api.name:yundt-cube-center-item}",
        path = "/v1/itemUnitConversion",
        url = "${yundt.cube.center.item.api:}")
public interface IItemUnitConversionApi {

    /**
    * 新增商品规格换算表
    *
    * @param addReqDto 商品规格换算表请求对象
    * @return 处理结果
    */
    @PostMapping("")
    @ApiOperation(value = "新增商品规格换算表", notes = "新增商品规格换算表")
    RestResponse<Long> addItemUnitConversion(@RequestBody ItemUnitConversionReqDto addReqDto);

    /**
    * 修改商品规格换算表
    *
    * @param modifyReqDto 商品规格换算表请求对象
    * @return 处理结果
    */
    @PutMapping("")
    @ApiOperation(value = "修改商品规格换算表", notes = "修改商品规格换算表")
    RestResponse<Void> modifyItemUnitConversion(@RequestBody ItemUnitConversionReqDto modifyReqDto);

    /**
     * 修改商品规格换算表
     *
     * @param conversionReqDtoList 商品规格换算表请求对象
     * @return 处理结果
     */
    @PostMapping("/batchCreate")
    @ApiOperation(value = "修改商品规格换算表", notes = "修改商品规格换算表")
    RestResponse<Void> batchCreateItemUnitConversion(@RequestBody List<ItemUnitConversionReqDto> conversionReqDtoList);

    /**
    * 删除商品规格换算表
    *
    * @param ids        商品规格换算表删除数据ID
    * @param instanceId 实例ID
    * @return 处理结果
    */
    @DeleteMapping("/{ids}")
    @ApiOperation(value = "删除商品规格换算表", notes = "删除商品规格换算表")
    RestResponse<Void> removeItemUnitConversion(@PathVariable("ids") String ids, @RequestParam("instanceId") Long instanceId);
}
