package com.dtyunxi.yundt.cube.center.item.api.b2b;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.DealerAddItemReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemChangeApplyDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import javax.validation.constraints.NotNull;

/**
 * @author :wuhui
 * @Desc:经销商店铺商品
 * @Date:2023/7/3 11:12
 */
@Api(
        tags = {"商品中心：经销商店铺商品"}
)
@FeignClient(
        name = "${yundt.cube.center.item.api.name:yundt-cube-center-item}",
        path = "/v1/dealer/shop/item",
        contextId = "com-dtyunxi-yundt-cube-center-item-api-b2b-query-IShopItemApi",
        url = "${yundt.cube.center.item.api:}"
)
public interface IShopItemApi {

    /**
     * 新增商品
     * @param dealerAddItemReqDto
     * @return 操作结果
     */
    @PostMapping(value = "/add")
    @ApiOperation(value = "新增商品", notes = "新增商品")
    RestResponse<Long> addItem(@Validated @NotNull @RequestBody DealerAddItemReqDto dealerAddItemReqDto);

}
