/*
 * @(#)InventoryException.java 1.0 2018-08-20
 *
 * Copyright (c) 2017, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.item.api.base;


import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.PriceTypeModReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.PriceTypeReqDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

/**
 * 商品价格接口
 *
 * @author 简树
 * @since 2.0.0
 */
@Api(tags = {"商品中心：商品价格接口服务"})
@FeignClient(name = "${yundt.cube.center.item.api.name:yundt-cube-center-item}",
        contextId = "com-dtyunxi-yundt-cube-center-item-api-base-IItemPriceTypeApi",
        path = "/v1/item/price",
        url = "${yundt.cube.center.item.api:}")
public interface IItemPriceTypeApi {
    /**
     * 添加价格类型
     *
     * @param priceType
     * @return
     */
    @PostMapping(value = "/type")
    @ApiOperation(value = "添加价格类型", notes = "添加价格类型信息")
    RestResponse<Long> addPriceType(@Validated @RequestBody PriceTypeReqDto priceType);

    /**
     * 修改价格类型
     *
     * @param priceType
     * @return
     */
    @ApiOperation(value = "修改价格类型", notes = "修改价格类型信息")
    @PutMapping(value = "/type")
    RestResponse<Void> modPriceType(@Validated @RequestBody PriceTypeModReqDto priceType);

    /**
     * 删除价格类型
     *
     * @param id         价格类型主键id
     * @param tenantId   租户
     * @param instanceId 实例
     * @return 操作结果
     * @author 双清
     */
    @DeleteMapping(value = "/type/{id}")
    @ApiOperation(value = "删除价格类型", notes = "删除价格类型")
    RestResponse<Void> removePriceType(@PathVariable("id") Long id,
                                       @RequestParam("instanceId") Long instanceId,
                                       @RequestParam("tenantId") Long tenantId);
}
