/**
 * @(#)ItemBusType.java 1.0 2020/6/12
 * <p>
 * Copyright (c) 2016, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.item.api.base.constants;

/**
 * 商品类型
 *
 * @author wu.sheng
 * @date 2020/6/12 10:20
 */
public enum ItemTypeEnum {
    GENERAL(1, "普通商品"),
    PRODUCT(2, "产品"),
    BUNDLE(3, "组合商品"),
    VIRTUAL(4,"虚拟商品") ;


    private Integer type;
    private String desc;

    ItemTypeEnum(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public static String getTypeEnum(Integer type) {
        for (ItemTypeEnum value : values()) {
            if (value.getType().equals(type)) {
                return value.getDesc();
            }
        }
        return null;
    }

    public Integer getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }
}
