/**
 * @(#)DirectoryCreateReqDto 1.0 20190118
 * <p>
 * Copyright (c) 2016, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.item.api.base.dto.request;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.List;

/**
 * 批量创建类目的请求dto
 *
 * @author 双清
 */
@ApiModel(value = "DirectoryCreateReqDto", description = "批量创建类目的请求dto")
public class DirectoryCreateReqDto extends BaseReqDto {

    @ApiModelProperty(name = "rootDir", value = "根目录信息，必填")
    private RootDirectoryReqDto rootDir;

    @ApiModelProperty(name = "childrenDir", value = "初始化目录树的目录项请求信息，选填")
    private List<ChildrenDirReqDto> childrenDirs;

    public RootDirectoryReqDto getRootDir() {
        return rootDir;
    }

    public void setRootDir(RootDirectoryReqDto rootDir) {
        this.rootDir = rootDir;
    }

    public List<ChildrenDirReqDto> getChildrenDirs() {
        return childrenDirs;
    }

    public void setChildrenDirs(List<ChildrenDirReqDto> childrenDirs) {
        this.childrenDirs = childrenDirs;
    }
}