package com.dtyunxi.yundt.cube.center.item.api.base.dto.request;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.List;

/**
 * 商品库请求dto
 *
 * @author: fuyun
 * @Date: 2020/6/19 16:14
 */
@ApiModel(value = "ProductReqDto", description = "商品库请求dto")
public class ProductReqDto {

    @ApiModelProperty(name = "id", value = "商品库id，新增不填，修改时需要填")
    private Long id;

    @ApiModelProperty(name = "itemName", value = "商品名称")
    private String itemName;

    @ApiModelProperty(name = "saleChannels", value = "可售渠道")
    private List<String> saleChannels;

    @ApiModelProperty(name = "backDirList", value = "后端类目：[1级，2级，3级]形式")
    private List<Long> backDirList;

    @ApiModelProperty(name = "backDirName", value = "类目名称")
    private String backDirName;

    @ApiModelProperty(name = "brandId", value = "品牌id")
    private Long brandId;

    @ApiModelProperty(name = "brand", value = "品牌名称")
    private String brand;

    @ApiModelProperty(name = "year", value = "商品年份 例如：2020")
    private Integer year;

    @ApiModelProperty(name = "imgUrlList", value = "商品图片")
    private List<String> imgUrlList;

    @ApiModelProperty(name = "itemCode", value = "商品编码")
    private String itemCode;

    @ApiModelProperty(name = "details", value = "产品详情:富文本格式")
    private String detail;

    @ApiModelProperty(name = "ifSpecs", value = "是否多规格类型，0-否，1-是")
    private Integer ifSpecs;

    @ApiModelProperty(name = "specs", value = "商品规格 ProductSpecReqDto")
    private List<ProductSpecReqDto> specs;

    @ApiModelProperty(name = "skus", value = "sku规格明细 ProductSkuReqDto")
    private List<ProductSkuReqDto> skus;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getItemName() {
        return itemName;
    }

    public void setItemName(String itemName) {
        this.itemName = itemName;
    }

    public List<String> getSaleChannels() {
        return saleChannels;
    }

    public void setSaleChannels(List<String> saleChannels) {
        this.saleChannels = saleChannels;
    }

    public List<Long> getBackDirList() {
        return backDirList;
    }

    public void setBackDirList(List<Long> backDirList) {
        this.backDirList = backDirList;
    }

    public String getBackDirName() {
        return backDirName;
    }

    public void setBackDirName(String backDirName) {
        this.backDirName = backDirName;
    }

    public Long getBrandId() {
        return brandId;
    }

    public void setBrandId(Long brandId) {
        this.brandId = brandId;
    }

    public String getBrand() {
        return brand;
    }

    public void setBrand(String brand) {
        this.brand = brand;
    }

    public Integer getYear() {
        return year;
    }

    public void setYear(Integer year) {
        this.year = year;
    }

    public List<String> getImgUrlList() {
        return imgUrlList;
    }

    public void setImgUrlList(List<String> imgUrlList) {
        this.imgUrlList = imgUrlList;
    }

    public String getItemCode() {
        return itemCode;
    }

    public void setItemCode(String itemCode) {
        this.itemCode = itemCode;
    }

    public String getDetail() {
        return detail;
    }

    public void setDetail(String detail) {
        this.detail = detail;
    }

    public Integer getIfSpecs() {
        return ifSpecs;
    }

    public void setIfSpecs(Integer ifSpecs) {
        this.ifSpecs = ifSpecs;
    }

    public List<ProductSpecReqDto> getSpecs() {
        return specs;
    }

    public void setSpecs(List<ProductSpecReqDto> specs) {
        this.specs = specs;
    }

    public List<ProductSkuReqDto> getSkus() {
        return skus;
    }

    public void setSkus(List<ProductSkuReqDto> skus) {
        this.skus = skus;
    }
}
