/**
 * @(#)ShelfTimeDetailDto 1.0 2019/3/1
 * <p>
 * Copyright (c) 2016, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.item.api.base.dto.request;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.Date;
import java.util.List;

/**
 * @author郑雨 2019/3/1
 */
@ApiModel(value = "ShelfTimeDetailReqDto", description = "定时上下架时间、允许下单时间设置")
public class ShelfTimeDetailReqDto extends BaseReqDto {

    @ApiModelProperty(name = "onShelfTime", value = "定时上架时间，选填，填写了为定时上架")
    private Date onShelfTime;

    @ApiModelProperty(name = "offShelfTime", value = "定时下架时间，选填了，填写了为定时下架")
    private Date offShelfTime;

    @ApiModelProperty(name = "allowOrderTimeReqDtoList", value = "允许下单时间范围，选填，填写了为该商品只在该时间范围能下单")
    private List<AllowOrderTimeReqDto> allowOrderTimeReqDtoList;

    public Date getOnShelfTime() {
        return onShelfTime;
    }

    public void setOnShelfTime(Date onShelfTime) {
        this.onShelfTime = onShelfTime;
    }

    public Date getOffShelfTime() {
        return offShelfTime;
    }

    public void setOffShelfTime(Date offShelfTime) {
        this.offShelfTime = offShelfTime;
    }

    public List<AllowOrderTimeReqDto> getAllowOrderTimeReqDtoList() {
        return allowOrderTimeReqDtoList;
    }

    public void setAllowOrderTimeReqDtoList(List<AllowOrderTimeReqDto> allowOrderTimeReqDtoList) {
        this.allowOrderTimeReqDtoList = allowOrderTimeReqDtoList;
    }
}
