/*
 * @(#)ItemSkuRespDto.java 1.0 2018-09-03
 *
 * 			Copyright (c) 2017, YUNXI. All rights reserved.
 * 			YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.dtyunxi.yundt.cube.center.item.api.base.dto.response;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;

/**
 * 商品规格扩展Dto
 *
 * @author 诺克
 * @since 2.0.0
 */
@ApiModel(value = "ItemSkuExtRespDto", description = "商品规格扩展Dto")
public class ItemSkuExtRespDto extends ItemSkuRespDto {

    @ApiModelProperty(name = "itemName",value = "商品名称")
    private String itemName;

    @ApiModelProperty(name = "itemName",value = "商品编码")
    private String itemCode;

    @ApiModelProperty(name = "brandName",value = "品牌名称")
    private String brandName;

    @ApiModelProperty(name = "brandId",value = "品牌ID")
    private Long brandId;

    @ApiModelProperty(name = "dirName",value = "后台类目名称")
    private String dirName;

    @ApiModelProperty(name = "dirId",value = "后台类目ID")
    private Long dirId;

    @ApiModelProperty(name = "imgPath",value = "商品图片")
    private String imgPath;

    @ApiModelProperty(name = "skuId",value = "skuID")
    private Long skuId;

    @ApiModelProperty(name = "skuCode",value = "sku编码")
    private String skuCode;
    @ApiModelProperty(name = "skuDesc",value = "规格描述-冗余字段(attr)")
    private String skuDesc;

    @ApiModelProperty(name = "subType", value = "商品子类型，1-产品，2-赠品，3-物料")
    private Integer subType;

    @ApiModelProperty(name = "itemType", value = "商品类型:1-商品  2-产品  默认1 3 -组合商品；4虚拟商品")
    private Integer itemType;

    @ApiModelProperty(name = "busType", value = "业务类型：0 普通； 1 社区团购 2 积分商品 默认0")
    private Integer busType;

    @ApiModelProperty(name = "unitName",value = "单位名称")
    private String unitName;

    //冗余-货品编码
    @ApiModelProperty(name = "cargoSerial", value = "货品编码")
    private String cargoSerial;

    //商品未上架的零售价：
    @ApiModelProperty(name = "itemPrice", value = "sku未上架的零售价")
    private BigDecimal itemPrice;

    @ApiModelProperty(name = "dosageForm", value = "剂型")
    private String dosageForm;

    public String getDosageForm() {
        return dosageForm;
    }

    public void setDosageForm(String dosageForm) {
        this.dosageForm = dosageForm;
    }

    public String getSkuCode() {
        return skuCode;
    }

    public void setSkuCode(String skuCode) {
        this.skuCode = skuCode;
    }

    public Integer getSubType() {
        return subType;
    }

    public void setSubType(Integer subType) {
        this.subType = subType;
    }

    public String getItemName() {
        return itemName;
    }

    public void setItemName(String itemName) {
        this.itemName = itemName;
    }

    public String getItemCode() {
        return itemCode;
    }

    public void setItemCode(String itemCode) {
        this.itemCode = itemCode;
    }

    public String getBrandName() {
        return brandName;
    }

    public void setBrandName(String brandName) {
        this.brandName = brandName;
    }

    public Long getBrandId() {
        return brandId;
    }

    public void setBrandId(Long brandId) {
        this.brandId = brandId;
    }

    public String getDirName() {
        return dirName;
    }

    public void setDirName(String dirName) {
        this.dirName = dirName;
    }

    public Long getDirId() {
        return dirId;
    }

    public void setDirId(Long dirId) {
        this.dirId = dirId;
    }

    public String getImgPath() {
        return imgPath;
    }

    public void setImgPath(String imgPath) {
        this.imgPath = imgPath;
    }

    public Long getSkuId() {
        return skuId;
    }

    public void setSkuId(Long skuId) {
        this.skuId = skuId;
    }

    public Integer getItemType() {
        return itemType;
    }

    public void setItemType(Integer itemType) {
        this.itemType = itemType;
    }

    public Integer getBusType() {
        return busType;
    }

    public void setBusType(Integer busType) {
        this.busType = busType;
    }

    public String getUnitName() {
        return unitName;
    }

    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }

    public String getCargoSerial() {
        return cargoSerial;
    }

    public void setCargoSerial(String cargoSerial) {
        this.cargoSerial = cargoSerial;
    }

    public BigDecimal getItemPrice() {
        return itemPrice;
    }

    public void setItemPrice(BigDecimal itemPrice) {
        this.itemPrice = itemPrice;
    }

    public String getSkuDesc() {
        return skuDesc;
    }
    public void setSkuDesc(String skuDesc) {
        this.skuDesc = skuDesc;
    }
}
