/**
 * @(#) ItemStorageDetailQueryRespDto.java 1.0 2018-12-04
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.item.api.base.dto.response;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.Date;

/**
 * 店铺商品库存详情响应Dto
 *
 * @author 魄罗
 * @since 2.0.0
 */
@ApiModel(value = "ItemStorageDetailQueryRespDto", description = "店铺商品库存详情响应Dto")
public class ItemStorageDetailQueryRespDto extends BaseRespDto {

    /**
     * 主键ID
     */
    @ApiModelProperty(name = "id", value = "主键ID")
    private Long id;
    /**
     * 上架ID
     */
    @ApiModelProperty(name = "shelfId", value = "上架ID")
    private Long shelfId;
    /**
     * 店铺ID
     */
    @ApiModelProperty(name = "shopId", value = "店铺ID")
    private Long shopId;
    /**
     * 渠道ID
     */
    @ApiModelProperty(name = "channelId", value = "渠道ID")
    private Long channelId;
    /**
     * 商品ID
     */
    @ApiModelProperty(name = "itemId", value = "商品ID")
    private Long itemId;
    /**
     * skuId
     */
    @ApiModelProperty(name = "skuId", value = "skuId")
    private Long skuId;
    /**
     * 可用商品库存数
     */
    @ApiModelProperty(name = "avaNum", value = "可用商品库存数")
    private Long avaNum;
    /**
     * 库存数
     */
    @ApiModelProperty(name = "balance", value = "库存数")
    private Long balance;
    /**
     * 已占用数量
     */
    @ApiModelProperty(name = "appending", value = "已占用数量")
    private Long appending;
    /**
     * 已只配数量
     */
    @ApiModelProperty(name = "allocated", value = "已只配数量")
    private Long allocated;
    /**
     * 预售数量
     */
    @ApiModelProperty(name = "presell", value = "预售数量")
    private Long presell;
    /**
     * 活动库存
     */
    @ApiModelProperty(name = "activity", value = "活动库存")
    private Long activity;
    /**
     * 库存有效日期
     */
    @ApiModelProperty(name = "inventoryEffectiveDate", value = "库存有效日期")
    private Date inventoryEffectiveDate;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getShelfId() {
        return shelfId;
    }

    public void setShelfId(Long shelfId) {
        this.shelfId = shelfId;
    }

    public Long getShopId() {
        return shopId;
    }

    public void setShopId(Long shopId) {
        this.shopId = shopId;
    }

    public Long getChannelId() {
        return channelId;
    }

    public void setChannelId(Long channelId) {
        this.channelId = channelId;
    }

    public Long getItemId() {
        return itemId;
    }

    public void setItemId(Long itemId) {
        this.itemId = itemId;
    }

    public Long getSkuId() {
        return skuId;
    }

    public void setSkuId(Long skuId) {
        this.skuId = skuId;
    }

    public Long getAvaNum() {
        return avaNum;
    }

    public void setAvaNum(Long avaNum) {
        this.avaNum = avaNum;
    }

    public Long getBalance() {
        return balance;
    }

    public void setBalance(Long balance) {
        this.balance = balance;
    }

    public Long getAppending() {
        return appending;
    }

    public void setAppending(Long appending) {
        this.appending = appending;
    }

    public Long getAllocated() {
        return allocated;
    }

    public void setAllocated(Long allocated) {
        this.allocated = allocated;
    }

    public Long getPresell() {
        return presell;
    }

    public void setPresell(Long presell) {
        this.presell = presell;
    }

    public Long getActivity() {
        return activity;
    }

    public void setActivity(Long activity) {
        this.activity = activity;
    }

    public Date getInventoryEffectiveDate() {
        return inventoryEffectiveDate;
    }

    public void setInventoryEffectiveDate(Date inventoryEffectiveDate) {
        this.inventoryEffectiveDate = inventoryEffectiveDate;
    }
}
