package com.dtyunxi.yundt.cube.center.item.api.common.enums;

import com.dtyunxi.yundt.cube.center.item.api.base.constants.ItemSkuStatusEnum;

/**
 * <p>Title:ItemEditStatus</p>
 * <p>Description: </p>
 *
 * @author yiyun
 * @date 2021/8/27 14:34
 * @since 0.1.0
 */
public enum ItemEditStatus {
    NOT_EDIT(1, "未编辑"),
    EDITED(2, "已编辑");

    private Integer status;
    private String desc;

    ItemEditStatus(Integer status, String desc) {
        this.status = status;
        this.desc = desc;
    }

    public static String getDesc(Integer index) {
        for (ItemSkuStatusEnum statusEnum : ItemSkuStatusEnum.values()) {
            if (statusEnum.getStatus().equals(index)) {
                return statusEnum.getDesc();
            }
        }
        return null;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

}
