package com.dtyunxi.yundt.cube.center.item.api.dto.request;

import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.BaseReqDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 根据sap更新商品信息
 *
 * @author 沐北
 * @since 2021-08-18
 */
@ApiModel(value = "ItemExtUpdateBySapReqDto", description = "根据sap更新商品信息")
@Data
public class ItemExtUpdateBySapReqDto extends BaseReqDto {
    @ApiModelProperty(name = "id", value = "商品id")
    private Long id;
    @ApiModelProperty(name = "name", value = "商品名称")
    private String name;
    @ApiModelProperty(name = "displayName", value = "显示名")
    private String displayName;

    @ApiModelProperty(name = "code", value = "商品编码")
    private String code;
    @ApiModelProperty(name = "itemCode", value = "商品编码")
    private String itemCode;
    @ApiModelProperty(name = "brandId", value = "品牌id")
    private Long brandId;

    @ApiModelProperty(name = "vitrual", value = "虚拟商品")
    private Boolean vitrual;
    @ApiModelProperty(name = "status", value = "状态(0已发布 1上架 2下架 3未发布 4禁用状态)")
    private Integer status;

    @ApiModelProperty(name = "type", value = "商品类型:1-商品  2-产品  默认1 3 -组合商品；4 虚拟商品")
    private Integer type;

    @ApiModelProperty(name = "ownerId", value = "创建人")
    private Long ownerId;
    @ApiModelProperty(name = "version", value = "商品版本")
    private Long version;
    @ApiModelProperty(name = "dirId", value = "目录Id")
    private Long dirId;

    @ApiModelProperty(name = "shippingTpl", value = "运费模板")
    private Long shippingTpl;


    @ApiModelProperty(name = "sellerId", value = "商户ID")
    private Long sellerId;
    @ApiModelProperty(name = "shopId", value = "店铺ID")
    private Long shopId;
    @ApiModelProperty(name = "spuid", value = "产品id")
    private Long spuid;
    @ApiModelProperty(name = "busType", value = "业务类型：0 普通； 1 社区团购  默认0")
    private Integer busType;
    @ApiModelProperty(name = "skuCode", value = "SKU编码")
    private String skuCode;


    @ApiModelProperty(name = "ifAvailableOffline", value = "是否线下可售，0-否，1-是")
    private Integer ifAvailableOffline;
    @ApiModelProperty(name = "bizType", value = "业务类型，1-商城商品查询，2-商品库商品查询")
    private Integer bizType;
    @ApiModelProperty(name = "cargoCode", value = "货品编码")
    private String cargoCode;
    @ApiModelProperty(name = "detail", value = "详情")
    private String detail;
    @ApiModelProperty(name = "brief", value = "介绍")
    private String brief;
    @ApiModelProperty(name = "productModel", value = "产品型号")
    private String productModel;

    @ApiModelProperty(name = "organizationId", value = "'组织id'")
    private String organizationId;
    @ApiModelProperty(name = "organizationName", value = "组织名称")
    private String organizationName;
    @ApiModelProperty(name = "saleChannel", value = "销售渠道")
    private String saleChannel;
    @ApiModelProperty(name = "prodGroup", value = "产品组")
    private String prodGroup;
    @ApiModelProperty(name = "prodClassCode", value = "产品型号")
    private String prodClassCode;
    /*产品类别*/
    @ApiModelProperty(name = "itemCategory", value = "产品类别")
    private String itemCategory;
    /*软件著作权书号*/
    @ApiModelProperty(name = "softwareWorkCode", value = "软件著作权书号")
    private String softwareWorkCode ;
    /*软件著作权名称*/
    @ApiModelProperty(name = "softwareWorkName", value = "软件著作权名称")
    private String softwareWorkName;
    /*适用水压*/
    @ApiModelProperty(name = "hydraulicPressure", value = "适用水压")
    private String hydraulicPressure ;
    /*燃气种类*/
    @ApiModelProperty(name = "gasClass", value = "燃气种类")
    private String gasClass;
    /*适用地区*/
    @ApiModelProperty(name = "applyArea", value = "适用地区")
    private String applyArea ;
    /*泄露电流*/
    @ApiModelProperty(name = "leakageCurrent", value = "泄露电流")
    private String leakageCurrent;
    /*防护等级*/
    @ApiModelProperty(name = "protectionLevel", value = "防护等级")
    private String protectionLevel;
    /*燃气额定电压*/
    @ApiModelProperty(name = "gasNominalVoltage", value = "燃气额定电压")
    private String gasNominalVoltage;
    /*热效率*/
    @ApiModelProperty(name = "thermalEfficiency", value = "热效率")
    private String thermalEfficiency;
    /*额定燃气高热值*/
    @ApiModelProperty(name = "heatingRating", value = "额定燃气高热值")
    private String heatingRating;
    /*安全阀泄压值*/
    @ApiModelProperty(name = "releasePressure", value = "安全阀泄压值")
    private String releasePressure;
    /*额定电功率*/
    @ApiModelProperty(name = "electricalRating", value = "额定电功率")
    private String electricalRating ;
    /*物料开票描述*/
    @ApiModelProperty(name = "invoiceDescription", value = "物料开票描述")
    private String invoiceDescription;
    /*燃气热值类型*/
    @ApiModelProperty(name = "gasHeatingType", value = "燃气热值类型")
    private String gasHeatingType;
    /*额定电压*/
    @ApiModelProperty(name = "nominalVoltage", value = "额定电压")
    private String nominalVoltage;
    /*额定频率*/
    @ApiModelProperty(name = "ratedFrequency", value = "额定频率")
    private String ratedFrequency;
    /*额度热负荷*/
    @ApiModelProperty(name = "nominalHeatLoad", value = "额度热负荷")
    private String nominalHeatLoad ;
    /*熄火保护装置类型*/
    @ApiModelProperty(name = "flameoutProtectionType", value = "熄火保护装置类型")
    private String flameoutProtectionType;
    /*额定燃气低热值*/
    @ApiModelProperty(name = "lowRating", value = "额定燃气低热值")
    private String lowRating;
    /*额定燃气相对密度*/
    @ApiModelProperty(name = "gasRatedRelativeDensity", value = "额定燃气相对密度")
    private String gasRatedRelativeDensity;
    /*额定产热水能力*/
    @ApiModelProperty(name = "productionWaterCapacity", value = "额定产热水能力")
    private String productionWaterCapacity;
    /*额定压力*/
    @ApiModelProperty(name = "nominalPressure", value = "额定压力")
    private String nominalPressure;
    /*开票规格型号*/
    @ApiModelProperty(name = "invoicingRulesCode", value = "开票规格型号")
    private String invoicingRulesCode;
    /*供应商*/
    @ApiModelProperty(name = "supplier", value = "供应商")
    private String supplier;
    /*产品定位*/
    @ApiModelProperty(name = "productPositioning", value = "产品定位")
    private String productPositioning;

    /*销售组*/
    @ApiModelProperty(name = "saleGroup", value = "销售组")
    private String saleGroup;
    /*税收分类名称*/
    @ApiModelProperty(name = "taxCategoryName", value = "税收分类名称")
    private String taxCategoryName;
    /**
     *产品层次2
     * */
    @ApiModelProperty(name = "prodLevelTwo", value = "产品层次2")
    private String prodLevelTwo ;
    /**
     *产品层次3
     * */
    @ApiModelProperty(name = "prodLevelThree", value = "产品层次3")
    private String prodLevelThree;
    /**
     *产品层次4
     * */
    @ApiModelProperty(name = "prodLevelFour", value = "产品层次4")
    private String prodLevelFour;
    /**
     *产品层次5
     * */
    @ApiModelProperty(name = "prodLevelFive", value = "产品层次5")
    private String prodLevelFive;

    /**
     *EN（69码）
     * */
    @ApiModelProperty(name = "enCode", value = "EN（69码）")
    private String enCode;

    /*
    * sku信息
    * */
    @ApiModelProperty(name = "itemSkuReqDto", value ="sku信息表")
    private ItemSkuSapUpdateReqDto itemSkuReqDto;


}
