/*
 * @(#)ItemPriceQueryReqDto.java 1.0 2022年01月08日
 *
 *  Copyright (c) 2016, YUNXI. All rights reserved.
 *  YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.dtyunxi.yundt.cube.center.item.api.dto.request;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * <p>Title:ItemPriceQueryReqDto</p>
 * <p>Description: </p>
 *
 * @author yiyun.lkh
 * @date 2022/1/8 23:44
 * @since 0.1.0
 */
@ApiModel(value = "ItemPriceQueryReqDto", description = "价格查询Dto对象")
public class ItemPriceQueryReqDto implements Serializable {

    @NotBlank(message = "客户编码不能为空!")
    @ApiModelProperty(name = "customerCode", value = "客户编码")
    private String customerCode;
    @ApiModelProperty(name = "isGroupBuy", value = "是否查团购价，是：true,否：false")
    private Boolean isGroupBuy;
    @ApiModelProperty(name = "priceIdentify", value = "1：国内价格，2：国外价格，不传默认查询国内价格")
    private String priceIdentify;
    @NotBlank(message = "商品编码不能为空")
    @ApiModelProperty(name = "itemCode", value = "商品编码，多个商品编码以','逗号隔开")
    private String itemCode;
    @ApiModelProperty(name = "currency", value = "币种,0:人名币 1:美元 2:日元 3:欧元 4:英镑 5:澳元 6:港元 7:澳门元")
    private Integer currency;


    public String getCustomerCode() {
        return customerCode;
    }

    public void setCustomerCode(String customerCode) {
        this.customerCode = customerCode;
    }

    public Boolean getGroupBuy() {
        return isGroupBuy;
    }

    public void setGroupBuy(Boolean groupBuy) {
        isGroupBuy = groupBuy;
    }

    public String getPriceIdentify() {
        return priceIdentify;
    }

    public void setPriceIdentify(String priceIdentify) {
        this.priceIdentify = priceIdentify;
    }

    public String getItemCode() {
        return itemCode;
    }

    public void setItemCode(String itemCode) {
        this.itemCode = itemCode;
    }

    public Integer getCurrency() {
        return currency;
    }

    public void setCurrency(Integer currency) {
        this.currency = currency;
    }
}
