/*
 * @(#)ItemListRespDto.java 1.0 2021年09月07日
 *
 *  Copyright (c) 2016, YUNXI. All rights reserved.
 *  YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.dtyunxi.yundt.cube.center.item.api.dto.response;

import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemMediasRespDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * <p>Title:ItemListRespDto</p>
 * <p>Description: </p>
 *
 * @author yiyun.lkh
 * @date 2021/9/7 13:47
 * @since 0.1.0
 */
@ApiModel(value = "ItemListRespDto", description = "商品列表数据Dto对象")
public class ItemListRespDto implements Serializable {

    @ApiModelProperty(name = "id",value = "商品ID")
    private Long id;

    @ApiModelProperty(name = "skuId", value = "skuID")
    private Long skuId;

    @ApiModelProperty(name = "dirId", value = "二级类目id")
    private Long dirId;

    @ApiModelProperty(name = "dirName", value = "二级类目名称")
    private String dirName;

    @ApiModelProperty(name = "categoryName", value = "一级类目名称")
    private String categoryName;

    @ApiModelProperty(name = "name", value = "商品名称")
    private String name;

    @ApiModelProperty(name = "code", value = "商品编码")
    private String code;

    @ApiModelProperty(name = "status", value = "上架状态")
    private Integer status;

    @ApiModelProperty(name = "updateTime", value = "更新时间")
    private Date updateTime;

    @ApiModelProperty(name = "medias", value = "商品图片")
    List<ItemMediasRespDto> medias;


    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getSkuId() {
        return skuId;
    }

    public void setSkuId(Long skuId) {
        this.skuId = skuId;
    }

    public Long getDirId() {
        return dirId;
    }

    public void setDirId(Long dirId) {
        this.dirId = dirId;
    }

    public String getDirName() {
        return dirName;
    }

    public void setDirName(String dirName) {
        this.dirName = dirName;
    }

    public String getCategoryName() {
        return categoryName;
    }

    public void setCategoryName(String categoryName) {
        this.categoryName = categoryName;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public Date getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public List<ItemMediasRespDto> getMedias() {
        return medias;
    }

    public void setMedias(List<ItemMediasRespDto> medias) {
        this.medias = medias;
    }
}
