package com.dtyunxi.yundt.cube.center.item.api.dto.response;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

@ApiModel(value = "ItemSkuPriceRespDto", description = "商品SKU价格数据Dto对象")
@Data
public class ItemSkuPriceRespDto  implements Serializable {

    @ApiModelProperty(name = "channelItemId", value = "平台商品ID")
    private String channelItemId;

    @ApiModelProperty(name = "channelItemCode", value = "渠道商品编码")
    private String channelItemCode;

    @ApiModelProperty(name = "channelSkuId", value = "平台skuID")
    private String channelSkuId;

    @ApiModelProperty(name = "channelSkuCode", value = "渠道sku编码")
    private String channelSkuCode;

    @ApiModelProperty(name = "itemId", value = "商品ID")
    private Long itemId;

    @ApiModelProperty(name = "itemCode",value = "商品编码")
    private String itemCode;

    @ApiModelProperty(name = "itemName",value = "商品名称")
    private String itemName;


    @ApiModelProperty(name = "skuId", value = "SKUID")
    private Long skuId;

    @ApiModelProperty(name = "skuCode", value = "sku编码")
    private String skuCode;

    @ApiModelProperty(name = "code", value = "SKU 名称")
    private String skuName;

    @ApiModelProperty(name = "price",value = "商品价格")
    private BigDecimal price;

    @ApiModelProperty( name = "batchNo",value = "商品批次号")
    private String batchNo;

    @ApiModelProperty(name = "itemType", value = "商品类型: 1 普通商品, 2 产品, 3 组合商品, 4 虚拟商品，5 赠品商品")
    private Integer itemType;

    @ApiModelProperty(name = "channelItemKey", value = "平台商品校验key")
    private String channelItemKey;

    @ApiModelProperty(name = "bundleReqDtos", value = "组合商品List")
    private List<RItemBundleRespDto> bundleReqDtos;

}
