package com.dtyunxi.yundt.cube.center.item.api.dto.response;

/**
 * @author suxia
 * @(#)$.java 1.0
 * <p>
 * Copyright (c) 2023$, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 * @date 2023/3/22
 */


import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.*;
import com.google.common.collect.Lists;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.util.List;

@ApiModel(
        value = "ItemSkuRespExtDto",
        description = "商品规格Dto"
)
public class ItemSkuRespExtDto extends BaseRespDto {
    @ApiModelProperty(
            name = "id",
            value = "id"
    )
    private Long id;
    @ApiModelProperty(
            name = "code",
            value = "编码"
    )
    private String code;
    @ApiModelProperty(
            name = "name",
            value = "规格名"
    )
    private String name;
    @ApiModelProperty(
            name = "cspuid",
            value = "产品规格"
    )
    private Long cspuid;
    @ApiModelProperty(
            name = "attr",
            value = "属性"
    )
    private String attr;
    @ApiModelProperty(
            name = "status",
            value = "状态"
    )
    private Integer status;
    @ApiModelProperty(
            name = "unit",
            value = "单位"
    )
    private String unit;
    @ApiModelProperty(
            name = "barCode",
            value = "识别条形码"
    )
    private String barCode;
    @ApiModelProperty(
            name = "bundles",
            value = "组合信息"
    )
    private String bundles;
    @ApiModelProperty(
            name = "effectiveStartTime",
            value = "有效的起始时间（例12:00）,有效日期上架当天"
    )
    private String effectiveStartTime;
    @ApiModelProperty(
            name = "effectiveEndTime",
            value = "有效的结束时间（例13:00）,有效日期上架当天"
    )
    private String effectiveEndTime;
    @ApiModelProperty(
            name = "inventoryQuantity",
            value = "虚拟商品库存数量"
    )
    private Long inventoryQuantity;
    @ApiModelProperty(
            name = "advanceSale",
            value = "是否预售(1是 2否)"
    )
    private Integer advanceSale;
    @ApiModelProperty(
            name = "discontinuationDate",
            value = "停售日期"
    )
    private String discontinuationDate;
    @ApiModelProperty(
            name = "instanceId",
            value = "应用实例ID"
    )
    private Long instanceId;
    @ApiModelProperty(
            name = "outterCode",
            value = "外部编码"
    )
    private String outterCode;
    @ApiModelProperty(
            name = "cargoCode",
            value = "货品编码"
    )
    private String cargoCode;
    @ApiModelProperty(
            name = "itemId",
            value = "商品id"
    )
    private Long itemId;
    @ApiModelProperty(
            name = "shelfAmount",
            value = "可卖数量=所有规格的可卖数量之和"
    )
    private Long shelfAmount;
    @ApiModelProperty(
            name = "balance",
            value = "库存数量"
    )
    private Long balance;
    @ApiModelProperty(
            name = "itemPriceList",
            value = "价格列表"
    )
    private List<ItemPriceRespDto> itemPriceList = Lists.newArrayList();
    @ApiModelProperty(
            name = "bundleItemList",
            value = "组合商品信息"
    )
    private List<BundleItemRespDto> bundleItemList = Lists.newArrayList();
    @ApiModelProperty(
            name = "medias",
            value = "商品sku的多媒体信息，选填"
    )
    private List<ItemMediasRespDto> medias = Lists.newArrayList();
    @ApiModelProperty(
            name = "ifAvailableOffline",
            value = "是否线下可售，0-否，1-是"
    )
    private Integer ifAvailableOffline;
    @ApiModelProperty(
            name = "safetyStock",
            value = "安全库存数"
    )
    private Integer safetyStock;
    @ApiModelProperty(
            name = "price",
            value = "定价"
    )
    private BigDecimal price;
    @ApiModelProperty(
            name = "salePrice",
            value = "零售价"
    )
    private BigDecimal salePrice;
    @ApiModelProperty(
            name = "cashLimit",
            value = "积分兑换数量限制"
    )
    private Integer cashLimit;
    @ApiModelProperty(
            name = "cashAmount",
            value = "积分兑换金额"
    )
    private BigDecimal cashAmount;
    @ApiModelProperty(
            name = "cashIntegral",
            value = "积分"
    )
    private Long cashIntegral;
    @ApiModelProperty(
            name = "cashType",
            value = "兑换类型：1积分2积分+金额"
    )
    private Integer cashType;
    @ApiModelProperty(
            name = "grossWeight",
            value = "毛重"
    )
    private BigDecimal grossWeight;
    @ApiModelProperty(
            name = "grossWeightUnit",
            value = "毛重单位"
    )
    private String grossWeightUnit;
    @ApiModelProperty(
            name = "netWeight",
            value = "净重"
    )
    private BigDecimal netWeight;
    @ApiModelProperty(
            name = "netWeightUnit",
            value = "净重单位"
    )
    private String netWeightUnit;
    @ApiModelProperty(
            name = "distribution",
            value = "是否分销：1是，0否"
    )
    private Integer distribution;
    @ApiModelProperty(
            name = "distribution",
            value = "分销佣金"
    )
    private BigDecimal distributionFee;
    @ApiModelProperty(
            name = "volume",
            value = "体积"
    )
    private BigDecimal volume;
    @ApiModelProperty(
            name = "volumeUnit",
            value = "体积单位"
    )
    private String volumeUnit;
    @ApiModelProperty(
            name = "freightTemplateId",
            value = "运费模板id"
    )
    private Long freightTemplateId;
    @ApiModelProperty(
            name = "freightTemplateName",
            value = "运费名称"
    )
    private String freightTemplateName;
    @ApiModelProperty(
            name = "PointsDeductionRespDto",
            value = "积分扣减规则"
    )
    private PointsDeductionRespDto pointsDeductionRespDto;
    @ApiModelProperty(
            name = "costPrice",
            value = "成本价"
    )
    private BigDecimal costPrice;
    @ApiModelProperty(
            name = "addPriceStatus",
            value = "0:关闭加价限制;1:开启加价限制"
    )
    private Integer addPriceStatus;
    @ApiModelProperty(
            name = "addPriceMode",
            value = "加价方式,0:使用默认值;1:自定义比例;2:自定义设置(固定值)"
    )
    private Integer addPriceMode;
    @ApiModelProperty(
            name = "addPriceMin",
            value = "限制加价下限;addPriceMod的值为0,1就位百分比;2为固定值(单位元)"
    )
    private String addPriceMin;
    @ApiModelProperty(
            name = "addPriceMax",
            value = "限制加价上限"
    )
    private String addPriceMax;

    /**
     * 规格单位
     */
    private String specsUnit;

    /**
     *  计量单位
     */
    private String calcuUnit;

    /**
     *  重量单位
     */
    private String weightUnit;

    /**
     * 内包装规格（PC长宽高）
     */
    private String pcSpecs;

    /**
     * 外包装规格（CAR长宽高）
     */
    private String carSpecs;

    /**
     * 换算因子
     */
    private String matrixing;

    private String launchDate;

    private String delistingDate;

    private String materialType;

    /*大小/量纲*/
    private String capacitySize;
    /*面板材质/特征效果*/
    private String panelMaterial;
    /*容积*/
    //String volume ;
    /*毛质量*/
    private String totalQuality;
    /*包装参考物料*/
    private String packingMaterial;
    /*包装外形尺寸*/
    private String packingSize;
    /*额定容积*/
    private String nominalVolume;
    /*净质量*/
    private String netQuality;
    /*嵌装开孔尺寸*/
    private String insertOpeningSize;
    /*基本单位*/
    private String basicUnit;
    /**
     *冻结标识
     * */
    private String freezeMark;
    /*规格*/
    //String specification ;
    /*销售组*/
    //String salesGroup ;

    public ItemSkuRespExtDto() {
    }

    public BigDecimal getCostPrice() {
        return this.costPrice;
    }

    public void setCostPrice(BigDecimal costPrice) {
        this.costPrice = costPrice;
    }

    public Integer getAddPriceStatus() {
        return this.addPriceStatus;
    }

    public void setAddPriceStatus(Integer addPriceStatus) {
        this.addPriceStatus = addPriceStatus;
    }

    public Integer getAddPriceMode() {
        return this.addPriceMode;
    }

    public void setAddPriceMode(Integer addPriceMode) {
        this.addPriceMode = addPriceMode;
    }

    public String getAddPriceMin() {
        return this.addPriceMin;
    }

    public void setAddPriceMin(String addPriceMin) {
        this.addPriceMin = addPriceMin;
    }

    public String getAddPriceMax() {
        return this.addPriceMax;
    }

    public void setAddPriceMax(String addPriceMax) {
        this.addPriceMax = addPriceMax;
    }

    public PointsDeductionRespDto getPointsDeductionRespDto() {
        return this.pointsDeductionRespDto;
    }

    public void setPointsDeductionRespDto(PointsDeductionRespDto pointsDeductionRespDto) {
        this.pointsDeductionRespDto = pointsDeductionRespDto;
    }

    public Long getFreightTemplateId() {
        return this.freightTemplateId;
    }

    public void setFreightTemplateId(Long freightTemplateId) {
        this.freightTemplateId = freightTemplateId;
    }

    public String getFreightTemplateName() {
        return this.freightTemplateName;
    }

    public void setFreightTemplateName(String freightTemplateName) {
        this.freightTemplateName = freightTemplateName;
    }

    public BigDecimal getVolume() {
        return this.volume;
    }

    public void setVolume(BigDecimal volume) {
        this.volume = volume;
    }

    public String getVolumeUnit() {
        return this.volumeUnit;
    }

    public void setVolumeUnit(String volumeUnit) {
        this.volumeUnit = volumeUnit;
    }

    public Integer getCashLimit() {
        return this.cashLimit;
    }

    public void setCashLimit(Integer cashLimit) {
        this.cashLimit = cashLimit;
    }

    public BigDecimal getCashAmount() {
        return this.cashAmount;
    }

    public void setCashAmount(BigDecimal cashAmount) {
        this.cashAmount = cashAmount;
    }

    public Long getCashIntegral() {
        return this.cashIntegral;
    }

    public void setCashIntegral(Long cashIntegral) {
        this.cashIntegral = cashIntegral;
    }

    public Integer getCashType() {
        return this.cashType;
    }

    public void setCashType(Integer cashType) {
        this.cashType = cashType;
    }

    public BigDecimal getGrossWeight() {
        return this.grossWeight;
    }

    public void setGrossWeight(BigDecimal grossWeight) {
        this.grossWeight = grossWeight;
    }

    public String getGrossWeightUnit() {
        return this.grossWeightUnit;
    }

    public void setGrossWeightUnit(String grossWeightUnit) {
        this.grossWeightUnit = grossWeightUnit;
    }

    public BigDecimal getNetWeight() {
        return this.netWeight;
    }

    public void setNetWeight(BigDecimal netWeight) {
        this.netWeight = netWeight;
    }

    public String getNetWeightUnit() {
        return this.netWeightUnit;
    }

    public void setNetWeightUnit(String netWeightUnit) {
        this.netWeightUnit = netWeightUnit;
    }

    public BigDecimal getPrice() {
        return this.price;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }

    public BigDecimal getSalePrice() {
        return this.salePrice;
    }

    public void setSalePrice(BigDecimal salePrice) {
        this.salePrice = salePrice;
    }

    public Long getBalance() {
        return this.balance;
    }

    public void setBalance(Long balance) {
        this.balance = balance;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Long getCspuid() {
        return this.cspuid;
    }

    public void setCspuid(Long cspuid) {
        this.cspuid = cspuid;
    }

    public String getAttr() {
        return this.attr;
    }

    public void setAttr(String attr) {
        this.attr = attr;
    }

    public Integer getStatus() {
        return this.status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public String getUnit() {
        return this.unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public String getBarCode() {
        return this.barCode;
    }

    public void setBarCode(String barCode) {
        this.barCode = barCode;
    }

    public String getBundles() {
        return this.bundles;
    }

    public void setBundles(String bundles) {
        this.bundles = bundles;
    }

    public Long getInstanceId() {
        return this.instanceId;
    }

    public void setInstanceId(Long instanceId) {
        this.instanceId = instanceId;
    }

    public List<ItemPriceRespDto> getItemPriceList() {
        return this.itemPriceList;
    }

    public void setItemPriceList(List<ItemPriceRespDto> itemPriceList) {
        this.itemPriceList = itemPriceList;
    }

    public List<BundleItemRespDto> getBundleItemList() {
        return this.bundleItemList;
    }

    public void setBundleItemList(List<BundleItemRespDto> bundleItemList) {
        this.bundleItemList = bundleItemList;
    }

    public List<ItemMediasRespDto> getMedias() {
        return this.medias;
    }

    public void setMedias(List<ItemMediasRespDto> medias) {
        this.medias = medias;
    }

    public Long getItemId() {
        return this.itemId;
    }

    public void setItemId(Long itemId) {
        this.itemId = itemId;
    }

    public Long getShelfAmount() {
        return this.shelfAmount;
    }

    public void setShelfAmount(Long shelfAmount) {
        this.shelfAmount = shelfAmount;
    }

    public String getOutterCode() {
        return this.outterCode;
    }

    public void setOutterCode(String outterCode) {
        this.outterCode = outterCode;
    }

    public String getEffectiveStartTime() {
        return this.effectiveStartTime;
    }

    public void setEffectiveStartTime(String effectiveStartTime) {
        this.effectiveStartTime = effectiveStartTime;
    }

    public String getEffectiveEndTime() {
        return this.effectiveEndTime;
    }

    public void setEffectiveEndTime(String effectiveEndTime) {
        this.effectiveEndTime = effectiveEndTime;
    }

    public Long getInventoryQuantity() {
        return this.inventoryQuantity;
    }

    public void setInventoryQuantity(Long inventoryQuantity) {
        this.inventoryQuantity = inventoryQuantity;
    }

    public Integer getAdvanceSale() {
        return this.advanceSale;
    }

    public void setAdvanceSale(Integer advanceSale) {
        this.advanceSale = advanceSale;
    }

    public String getDiscontinuationDate() {
        return this.discontinuationDate;
    }

    public void setDiscontinuationDate(String discontinuationDate) {
        this.discontinuationDate = discontinuationDate;
    }

    public Integer getIfAvailableOffline() {
        return this.ifAvailableOffline;
    }

    public void setIfAvailableOffline(Integer ifAvailableOffline) {
        this.ifAvailableOffline = ifAvailableOffline;
    }

    public Integer getSafetyStock() {
        return this.safetyStock;
    }

    public void setSafetyStock(Integer safetyStock) {
        this.safetyStock = safetyStock;
    }

    public String getCargoCode() {
        return this.cargoCode;
    }

    public void setCargoCode(String cargoCode) {
        this.cargoCode = cargoCode;
    }

    public Integer getDistribution() {
        return this.distribution;
    }

    public void setDistribution(Integer distribution) {
        this.distribution = distribution;
    }

    public BigDecimal getDistributionFee() {
        return this.distributionFee;
    }

    public void setDistributionFee(BigDecimal distributionFee) {
        this.distributionFee = distributionFee;
    }

    public String getSpecsUnit() {
        return specsUnit;
    }

    public void setSpecsUnit(String specsUnit) {
        this.specsUnit = specsUnit;
    }

    public String getCalcuUnit() {
        return calcuUnit;
    }

    public void setCalcuUnit(String calcuUnit) {
        this.calcuUnit = calcuUnit;
    }

    public String getWeightUnit() {
        return weightUnit;
    }

    public void setWeightUnit(String weightUnit) {
        this.weightUnit = weightUnit;
    }

    public String getPcSpecs() {
        return pcSpecs;
    }

    public void setPcSpecs(String pcSpecs) {
        this.pcSpecs = pcSpecs;
    }

    public String getCarSpecs() {
        return carSpecs;
    }

    public void setCarSpecs(String carSpecs) {
        this.carSpecs = carSpecs;
    }

    public String getMatrixing() {
        return matrixing;
    }

    public void setMatrixing(String matrixing) {
        this.matrixing = matrixing;
    }

    public String getLaunchDate() {
        return launchDate;
    }

    public void setLaunchDate(String launchDate) {
        this.launchDate = launchDate;
    }

    public String getDelistingDate() {
        return delistingDate;
    }

    public void setDelistingDate(String delistingDate) {
        this.delistingDate = delistingDate;
    }

    public String getMaterialType() {
        return materialType;
    }

    public void setMaterialType(String materialType) {
        this.materialType = materialType;
    }

    public String getCapacitySize() {
        return capacitySize;
    }

    public void setCapacitySize(String capacitySize) {
        this.capacitySize = capacitySize;
    }

    public String getPanelMaterial() {
        return panelMaterial;
    }

    public void setPanelMaterial(String panelMaterial) {
        this.panelMaterial = panelMaterial;
    }

    public String getTotalQuality() {
        return totalQuality;
    }

    public void setTotalQuality(String totalQuality) {
        this.totalQuality = totalQuality;
    }

    public String getPackingMaterial() {
        return packingMaterial;
    }

    public void setPackingMaterial(String packingMaterial) {
        this.packingMaterial = packingMaterial;
    }

    public String getPackingSize() {
        return packingSize;
    }

    public void setPackingSize(String packingSize) {
        this.packingSize = packingSize;
    }

    public String getNominalVolume() {
        return nominalVolume;
    }

    public void setNominalVolume(String nominalVolume) {
        this.nominalVolume = nominalVolume;
    }

    public String getNetQuality() {
        return netQuality;
    }

    public void setNetQuality(String netQuality) {
        this.netQuality = netQuality;
    }

    public String getInsertOpeningSize() {
        return insertOpeningSize;
    }

    public void setInsertOpeningSize(String insertOpeningSize) {
        this.insertOpeningSize = insertOpeningSize;
    }

    public String getBasicUnit() {
        return basicUnit;
    }

    public void setBasicUnit(String basicUnit) {
        this.basicUnit = basicUnit;
    }

    public String getFreezeMark() {
        return freezeMark;
    }

    public void setFreezeMark(String freezeMark) {
        this.freezeMark = freezeMark;
    }
}

