package com.dtyunxi.yundt.cube.center.item.api.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.item.api.dto.response.RItemBundleRespDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.request.ItemRelationQueryConditionReqDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.response.*;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
* 商品关系对照表服务接口
*
* @author yiyun
* @since 2021-09-08
*/
@Api(tags = {"商品中心：商品关系对照表服务"})
@FeignClient(
    contextId = "com-dtyunxi-yundt-cube-center-item-api-query-IItemRelationComparisonQueryApi",
    name = "${yundt.cube.center.item.api.name:yundt-cube-center-item}",
    path = "/v1/itemext/relation",
    url = "${yundt.cube.center.item.api:}"
)
public interface IItemExtRelationComparisonQueryApi {

    /**
    * 根据id查询商品关系对照表
    *
    * @param id 商品关系对照表id
    * @return   商品关系对照表数据
    */
    @GetMapping("/{id}")
    @ApiOperation(value = "根据id查询商品关系对照表", notes = "根据id查询商品关系对照表")
    RestResponse<ItemExtRelationComparisonRespDto> queryById(@PathVariable("id") Long id);

    /**
     * 根据id查询商品映射关系详情
     * @param id
     * @return
     */
    @GetMapping("/detail/{id}")
    @ApiOperation(value = "根据id查询商品映射关系详情", notes = "根据id查询商品映射关系详情")
    RestResponse<ItemComparisonRelationRespDto> queryRelationById(@PathVariable("id") Long id);

    /**
    * 商品关系对照表分页数据
    *
    * @param filter   商品关系对照表查询条件
    * @param pageNum  当前页
    * @param pageSize 页大小
    * @return 商品关系对照表分页数据
    */
    @GetMapping("/page")
    @ApiOperation(value = "商品关系对照表分页数据", notes = "根据filter查询条件查询商品关系对照表数据，filter=ItemRelationComparisonReqDto")
    RestResponse<PageInfo<ItemExtRelationComparisonRespDto>> queryByPage(@RequestParam("filter") String filter,
                                                                         @RequestParam(name = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                                         @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize);

    /**
     * 根据店铺查询商品对照关系
     * @param shopCodes
     * @return
     */
    @PostMapping("/queryRelationList")
    @ApiOperation(value = "根据店铺查询商品对照关系", notes = "根据店铺查询商品对照关系")
    RestResponse<List<ItemExtRelationComparisonRespDto>> queryRelationByShopList(@RequestBody List<String> shopCodes);


    /**
     * 商品关系对照表分页数据
     * @param queryConditionReqDto
     * @return
     */
    @PostMapping("/list")
    @ApiOperation(value = "商品关系对照表分页数据", notes = "商品关系对照表分页数据")
    RestResponse<PageInfo<ItemRelationInfoRespDto>> queryItemRelationByPage(@RequestBody ItemRelationQueryConditionReqDto queryConditionReqDto);


    /**
     * 导出映射关系
     * @param queryConditionReqDto
     * @return
     */
    @PostMapping("/exportRelation")
    @ApiOperation(value = "导出映射关系", notes = "导出映射关系")
    RestResponse<PageInfo<ItemRelationInfoRespDto>> exportRelation(@RequestBody ItemRelationQueryConditionReqDto queryConditionReqDto,
                                                                   @RequestParam(name = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                                   @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize);

    /**
     * 商品映射数据导出
     * @param queryConditionReqDto
     * @return
     */
    @PostMapping("/export")
    @ApiOperation(value = "商品映射数据导出", notes = "商品映射数据导出")
    RestResponse<String> export(@RequestBody ItemRelationQueryConditionReqDto queryConditionReqDto);


    @GetMapping("/{channelSkuCode}")
    @ApiOperation(value = "根据渠道skucode查询中台商品、sku 基本信息", notes = "根据渠道skucode查询中台商品、sku 基本信息")
    RestResponse<ItemSkuPriceRespDto> queryItemSkuPriceByChnSkuCode(@PathVariable("channelSkuCode") String channelSkuCode);


    @PostMapping("/queryItemSkuPriceByChnSkuCodeList")
    @ApiOperation(value = "根据渠道skucode查询中台商品、sku 基本信息", notes = "根据渠道skucode查询中台商品、sku 基本信息")
    RestResponse<List<ItemSkuPriceRespDto>> queryItemSkuPriceByChnSkuCodeList(@RequestBody List<String> channelSkuCodeList);

    @PostMapping("/queryByChannelItemCodes")
    @ApiOperation(value = "商品关系对照表分页数据(channelItemCodes)", notes = "商品关系对照表分页数据(channelItemCodes)")
    RestResponse<List<ItemRelationInfoRespDto>> queryByChannelItemCodes(@RequestBody List<String> channelItemCodes);

    @PostMapping("/queryRelationByTypeCodeList")
    @ApiOperation(value = "根据type、codeList查询商品关系映射", notes = "codyType定义：chnItemId/chnItemCode/chnSkuId/chnSkuCode")
    RestResponse<List<ItemSkuPriceRespDto>> queryRelationByTypeCodeList(@RequestBody List<String> codeList, @RequestParam(name = "codeType") String codeType);

    @PostMapping("/queryRelationByTypeCodeListNew")
    @ApiOperation(value = "根据type、codeList查询商品关系映射", notes = "codyType定义：chnItemId/chnItemCode/chnSkuId/chnSkuCode")
    RestResponse<List<ItemSkuPriceRespDto>> queryRelationByTypeCodeListNew(@RequestBody List<String> codeList, @RequestParam(name = "codeType") String codeType, @RequestParam(name = "shopCode") String shopCode);

    @PostMapping("/queryRItemBundleByItemIds")
    @ApiOperation(value = "根据商品IDList 查询组合商品明细", notes = "根据商品IDList 查询组合商品明细")
    RestResponse<List<RItemBundleRespDto>> queryRItemBundleByItemIds(@RequestBody List<Long> itemIdList);

    @PostMapping("/queryRItemBundleBySkuCodes")
    @ApiOperation(value = "根据 skuCodeList 查询组合商品明细", notes = "根据 skuCodeList 查询组合商品明细")
    RestResponse<List<RItemBundleQueryRespDto>> queryRItemBundleBySkuCodes(@RequestBody List<String> skuCodeList);

    @PostMapping("/queryRelationByItemKeysAndShopCode")
    @ApiOperation(value = "根据channelItemKeyList、shopCode查询商品关系映射", notes = "根据channelItemKeyList、shopCode查询商品关系映射,channelItemKeyList 平台的商品编码key集合，key的组合规则：channel_sku_code + channel_sku_Id + channel_item_code + channel_item_Id")
    RestResponse<List<ItemSkuPriceRespDto>> queryRelationByItemKeysAndShopCode(@RequestBody List<String> channelItemKeyList, @RequestParam(name = "shopCode") String shopCode);
}
